/*
 * Decompiled with CFR 0.152.
 */
package dyvil.reflect.types;

import dyvil.reflect.types.Type;

public final class PrimitiveType
implements Type {
    private static final int VOID_CODE = 0;
    private static final int BOOLEAN_CODE = 1;
    private static final int BYTE_CODE = 2;
    private static final int SHORT_CODE = 3;
    private static final int CHAR_CODE = 4;
    private static final int INT_CODE = 5;
    private static final int LONG_CODE = 6;
    private static final int FLOAT_CODE = 7;
    private static final int DOUBLE_CODE = 8;
    private static final PrimitiveType[] LOOKUP = new PrimitiveType[9];
    public static final PrimitiveType VOID = new PrimitiveType(0, Void.TYPE);
    public static final PrimitiveType BOOLEAN = new PrimitiveType(1, Boolean.TYPE);
    public static final PrimitiveType BYTE = new PrimitiveType(2, Byte.TYPE);
    public static final PrimitiveType SHORT = new PrimitiveType(3, Short.TYPE);
    public static final PrimitiveType CHAR = new PrimitiveType(4, Character.TYPE);
    public static final PrimitiveType INT = new PrimitiveType(5, Integer.TYPE);
    public static final PrimitiveType LONG = new PrimitiveType(6, Long.TYPE);
    public static final PrimitiveType FLOAT = new PrimitiveType(7, Float.TYPE);
    public static final PrimitiveType DOUBLE = new PrimitiveType(8, Double.TYPE);
    private final int id;
    private final Class theClass;

    public static PrimitiveType apply(Class<?> theClass) {
        for (PrimitiveType type : LOOKUP) {
            if (type.theClass != theClass) continue;
            return type;
        }
        return null;
    }

    private PrimitiveType(int id, Class<?> theClass) {
        this.id = id;
        this.theClass = theClass;
        PrimitiveType.LOOKUP[id] = this;
    }

    @Override
    public String name() {
        switch (this.id) {
            case 0: {
                return "void";
            }
            case 1: {
                return "boolean";
            }
            case 2: {
                return "byte";
            }
            case 3: {
                return "short";
            }
            case 4: {
                return "char";
            }
            case 5: {
                return "int";
            }
            case 6: {
                return "long";
            }
            case 7: {
                return "float";
            }
            case 8: {
                return "double";
            }
        }
        return null;
    }

    @Override
    public String qualifiedName() {
        return this.name();
    }

    public Class erasure() {
        return this.theClass;
    }

    @Override
    public String toString() {
        return this.name();
    }

    @Override
    public void appendSignature(StringBuilder builder) {
        switch (this.id) {
            case 0: {
                builder.append('V');
                return;
            }
            case 1: {
                builder.append('Z');
                return;
            }
            case 2: {
                builder.append('B');
                return;
            }
            case 3: {
                builder.append('S');
                return;
            }
            case 4: {
                builder.append('C');
                return;
            }
            case 5: {
                builder.append('I');
                return;
            }
            case 6: {
                builder.append('J');
                return;
            }
            case 7: {
                builder.append('F');
                return;
            }
            case 8: {
                builder.append('D');
                return;
            }
        }
    }

    @Override
    public void appendGenericSignature(StringBuilder builder) {
        switch (this.id) {
            case 0: {
                builder.append("Ljava/lang/Void;");
                return;
            }
            case 1: {
                builder.append("Ljava/lang/Boolean;");
                return;
            }
            case 2: {
                builder.append("Ljava/lang/Byte;");
                return;
            }
            case 3: {
                builder.append("Ljava/lang/Short;");
                return;
            }
            case 4: {
                builder.append("Ljava/lang/Char;");
                return;
            }
            case 5: {
                builder.append("Ljava/lang/Integer;");
                return;
            }
            case 6: {
                builder.append("Ljava/lang/Long;");
                return;
            }
            case 7: {
                builder.append("Ljava/lang/Float;");
                return;
            }
            case 8: {
                builder.append("Ljava/lang/Double;");
                return;
            }
        }
    }
}

