/*
 * Decompiled with CFR 0.152.
 */
package dyvil.reflect;

import dyvil.annotation.internal.NonNull;
import dyvilx.tools.asm.util.Printer;

public interface Opcodes {
    public static final int NOP = 0;
    public static final int ACONST_NULL = 1;
    public static final int ICONST_M1 = 2;
    public static final int ICONST_0 = 3;
    public static final int ICONST_1 = 4;
    public static final int ICONST_2 = 5;
    public static final int ICONST_3 = 6;
    public static final int ICONST_4 = 7;
    public static final int ICONST_5 = 8;
    public static final int LCONST_0 = 9;
    public static final int LCONST_1 = 10;
    public static final int FCONST_0 = 11;
    public static final int FCONST_1 = 12;
    public static final int FCONST_2 = 13;
    public static final int DCONST_0 = 14;
    public static final int DCONST_1 = 15;
    public static final int BIPUSH = 16;
    public static final int SIPUSH = 17;
    public static final int LDC = 18;
    public static final int ILOAD = 21;
    public static final int LLOAD = 22;
    public static final int FLOAD = 23;
    public static final int DLOAD = 24;
    public static final int ALOAD = 25;
    public static final int IALOAD = 46;
    public static final int LALOAD = 47;
    public static final int FALOAD = 48;
    public static final int DALOAD = 49;
    public static final int AALOAD = 50;
    public static final int BALOAD = 51;
    public static final int CALOAD = 52;
    public static final int SALOAD = 53;
    public static final int ISTORE = 54;
    public static final int LSTORE = 55;
    public static final int FSTORE = 56;
    public static final int DSTORE = 57;
    public static final int ASTORE = 58;
    public static final int IASTORE = 79;
    public static final int LASTORE = 80;
    public static final int FASTORE = 81;
    public static final int DASTORE = 82;
    public static final int AASTORE = 83;
    public static final int BASTORE = 84;
    public static final int CASTORE = 85;
    public static final int SASTORE = 86;
    public static final int POP = 87;
    public static final int POP2 = 88;
    public static final int DUP = 89;
    public static final int DUP_X1 = 90;
    public static final int DUP_X2 = 91;
    public static final int DUP2 = 92;
    public static final int DUP2_X1 = 93;
    public static final int DUP2_X2 = 94;
    public static final int SWAP = 95;
    public static final int IADD = 96;
    public static final int LADD = 97;
    public static final int FADD = 98;
    public static final int DADD = 99;
    public static final int ISUB = 100;
    public static final int LSUB = 101;
    public static final int FSUB = 102;
    public static final int DSUB = 103;
    public static final int IMUL = 104;
    public static final int LMUL = 105;
    public static final int FMUL = 106;
    public static final int DMUL = 107;
    public static final int IDIV = 108;
    public static final int LDIV = 109;
    public static final int FDIV = 110;
    public static final int DDIV = 111;
    public static final int IREM = 112;
    public static final int LREM = 113;
    public static final int FREM = 114;
    public static final int DREM = 115;
    public static final int INEG = 116;
    public static final int LNEG = 117;
    public static final int FNEG = 118;
    public static final int DNEG = 119;
    public static final int ISHL = 120;
    public static final int LSHL = 121;
    public static final int ISHR = 122;
    public static final int LSHR = 123;
    public static final int IUSHR = 124;
    public static final int LUSHR = 125;
    public static final int IAND = 126;
    public static final int LAND = 127;
    public static final int IOR = 128;
    public static final int LOR = 129;
    public static final int IXOR = 130;
    public static final int LXOR = 131;
    public static final int IINC = 132;
    public static final int I2L = 133;
    public static final int I2F = 134;
    public static final int I2D = 135;
    public static final int L2I = 136;
    public static final int L2F = 137;
    public static final int L2D = 138;
    public static final int F2I = 139;
    public static final int F2L = 140;
    public static final int F2D = 141;
    public static final int D2I = 142;
    public static final int D2L = 143;
    public static final int D2F = 144;
    public static final int I2B = 145;
    public static final int I2C = 146;
    public static final int I2S = 147;
    public static final int LCMP = 148;
    public static final int FCMPL = 149;
    public static final int FCMPG = 150;
    public static final int DCMPL = 151;
    public static final int DCMPG = 152;
    public static final int IFEQ = 153;
    public static final int IFNE = 154;
    public static final int IFLT = 155;
    public static final int IFGE = 156;
    public static final int IFGT = 157;
    public static final int IFLE = 158;
    public static final int IF_ICMPEQ = 159;
    public static final int IF_ICMPNE = 160;
    public static final int IF_ICMPLT = 161;
    public static final int IF_ICMPGE = 162;
    public static final int IF_ICMPGT = 163;
    public static final int IF_ICMPLE = 164;
    public static final int IF_ACMPEQ = 165;
    public static final int IF_ACMPNE = 166;
    public static final int GOTO = 167;
    public static final int JSR = 168;
    public static final int RET = 169;
    public static final int TABLESWITCH = 170;
    public static final int LOOKUPSWITCH = 171;
    public static final int IRETURN = 172;
    public static final int LRETURN = 173;
    public static final int FRETURN = 174;
    public static final int DRETURN = 175;
    public static final int ARETURN = 176;
    public static final int RETURN = 177;
    public static final int GETSTATIC = 178;
    public static final int PUTSTATIC = 179;
    public static final int GETFIELD = 180;
    public static final int PUTFIELD = 181;
    public static final int INVOKEVIRTUAL = 182;
    public static final int INVOKESPECIAL = 183;
    public static final int INVOKESTATIC = 184;
    public static final int INVOKEINTERFACE = 185;
    public static final int INVOKEDYNAMIC = 186;
    public static final int NEW = 187;
    public static final int NEWARRAY = 188;
    public static final int ANEWARRAY = 189;
    public static final int ARRAYLENGTH = 190;
    public static final int ATHROW = 191;
    public static final int CHECKCAST = 192;
    public static final int INSTANCEOF = 193;
    public static final int MONITORENTER = 194;
    public static final int MONITOREXIT = 195;
    public static final int MULTIANEWARRAY = 197;
    public static final int IFNULL = 198;
    public static final int IFNONNULL = 199;
    public static final int LOAD_0 = -1;
    public static final int LOAD_1 = -2;
    public static final int LOAD_2 = -3;
    public static final int LCONST_M1 = 264;
    public static final int BNOT = 270;
    public static final int INOT = 271;
    public static final int LNOT = 272;
    public static final int L2B = 280;
    public static final int L2S = 281;
    public static final int L2C = 282;
    public static final int F2B = 283;
    public static final int F2S = 284;
    public static final int F2C = 285;
    public static final int D2B = 286;
    public static final int D2S = 287;
    public static final int D2C = 289;
    public static final int ICMPEQ = 290;
    public static final int ICMPNE = 291;
    public static final int ICMPLT = 292;
    public static final int ICMPGE = 293;
    public static final int ICMPGT = 294;
    public static final int ICMPLE = 295;
    public static final int LCMPEQ = 296;
    public static final int LCMPNE = 297;
    public static final int LCMPLT = 298;
    public static final int LCMPGE = 299;
    public static final int LCMPGT = 300;
    public static final int LCMPLE = 301;
    public static final int FCMPEQ = 302;
    public static final int FCMPNE = 303;
    public static final int FCMPLT = 304;
    public static final int FCMPGE = 305;
    public static final int FCMPGT = 306;
    public static final int FCMPLE = 307;
    public static final int DCMPEQ = 308;
    public static final int DCMPNE = 309;
    public static final int DCMPLT = 310;
    public static final int DCMPGE = 311;
    public static final int DCMPGT = 312;
    public static final int DCMPLE = 313;
    public static final int ACMPEQ = 314;
    public static final int ACMPNE = 315;
    public static final int IS_NULL = 316;
    public static final int IS_NONNULL = 317;
    public static final int IF_LCMPEQ = 330;
    public static final int IF_LCMPNE = 331;
    public static final int IF_LCMPLT = 332;
    public static final int IF_LCMPGE = 333;
    public static final int IF_LCMPGT = 334;
    public static final int IF_LCMPLE = 335;
    public static final int IF_FCMPEQ = 336;
    public static final int IF_FCMPNE = 337;
    public static final int IF_FCMPLT = 338;
    public static final int IF_FCMPGE = 339;
    public static final int IF_FCMPGT = 340;
    public static final int IF_FCMPLE = 341;
    public static final int IF_DCMPEQ = 342;
    public static final int IF_DCMPNE = 343;
    public static final int IF_DCMPLT = 344;
    public static final int IF_DCMPGE = 345;
    public static final int IF_DCMPGT = 346;
    public static final int IF_DCMPLE = 347;
    public static final int EQ0 = 348;
    public static final int NE0 = 349;
    public static final int LT0 = 350;
    public static final int GE0 = 351;
    public static final int GT0 = 352;
    public static final int LE0 = 355;
    public static final int SWAP2 = 400;
    public static final int AUTO_SWAP = 411;
    public static final int AUTO_POP = 412;
    public static final int AUTO_DUP = 414;
    public static final int AUTO_DUP_X1 = 415;
    public static final int AUTO_LOAD = 430;
    public static final int AUTO_STORE = 431;
    public static final int OBJECT_EQUALS = 450;

    public static String toString(int op) {
        return Printer.OPCODES[op];
    }

    public static int parseOpcode(@NonNull String opcode) {
        int len = Printer.OPCODES.length;
        for (int i = 0; i < len; ++i) {
            if (!opcode.equalsIgnoreCase(Printer.OPCODES[i])) continue;
            return i;
        }
        return -1;
    }

    public static boolean isReturnOpcode(int opcode) {
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLoadOpcode(int opcode) {
        switch (opcode) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStoreOpcode(int opcode) {
        switch (opcode) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return true;
            }
        }
        return false;
    }

    public static boolean isFieldOpcode(int opcode) {
        switch (opcode) {
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMethodOpcode(int opcode) {
        switch (opcode) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                return true;
            }
        }
        return false;
    }

    public static boolean isFieldOrMethodOpcode(int opcode) {
        switch (opcode) {
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                return true;
            }
        }
        return false;
    }

    public static boolean isJumpOpcode(int opcode) {
        return opcode >= 153 && opcode <= 168 || opcode == 198 || opcode == 199 || opcode >= 330 && opcode <= 347;
    }

    public static int getInverseOpcode(int opcode) {
        switch (opcode) {
            case 348: {
                return 349;
            }
            case 349: {
                return 348;
            }
            case 350: {
                return 351;
            }
            case 351: {
                return 350;
            }
            case 352: {
                return 355;
            }
            case 355: {
                return 352;
            }
            case 153: {
                return 154;
            }
            case 154: {
                return 153;
            }
            case 155: {
                return 156;
            }
            case 156: {
                return 155;
            }
            case 157: {
                return 158;
            }
            case 158: {
                return 157;
            }
            case 290: {
                return 291;
            }
            case 291: {
                return 290;
            }
            case 293: {
                return 292;
            }
            case 292: {
                return 293;
            }
            case 295: {
                return 294;
            }
            case 294: {
                return 295;
            }
            case 159: {
                return 160;
            }
            case 160: {
                return 159;
            }
            case 161: {
                return 162;
            }
            case 162: {
                return 161;
            }
            case 163: {
                return 164;
            }
            case 164: {
                return 163;
            }
            case 296: {
                return 297;
            }
            case 297: {
                return 296;
            }
            case 298: {
                return 299;
            }
            case 299: {
                return 298;
            }
            case 300: {
                return 301;
            }
            case 301: {
                return 300;
            }
            case 330: {
                return 331;
            }
            case 331: {
                return 330;
            }
            case 332: {
                return 333;
            }
            case 333: {
                return 332;
            }
            case 334: {
                return 335;
            }
            case 335: {
                return 334;
            }
            case 302: {
                return 303;
            }
            case 303: {
                return 302;
            }
            case 304: {
                return 305;
            }
            case 305: {
                return 304;
            }
            case 306: {
                return 307;
            }
            case 307: {
                return 306;
            }
            case 336: {
                return 337;
            }
            case 337: {
                return 336;
            }
            case 338: {
                return 339;
            }
            case 339: {
                return 338;
            }
            case 340: {
                return 341;
            }
            case 341: {
                return 340;
            }
            case 308: {
                return 309;
            }
            case 309: {
                return 308;
            }
            case 310: {
                return 311;
            }
            case 311: {
                return 310;
            }
            case 312: {
                return 313;
            }
            case 313: {
                return 312;
            }
            case 342: {
                return 343;
            }
            case 343: {
                return 342;
            }
            case 344: {
                return 345;
            }
            case 345: {
                return 344;
            }
            case 346: {
                return 347;
            }
            case 347: {
                return 346;
            }
            case 314: {
                return 315;
            }
            case 315: {
                return 314;
            }
            case 165: {
                return 166;
            }
            case 166: {
                return 165;
            }
            case 316: {
                return 317;
            }
            case 317: {
                return 316;
            }
            case 198: {
                return 199;
            }
            case 199: {
                return 198;
            }
        }
        return -1;
    }

    public static int getJumpOpcode(int opcode) {
        switch (opcode) {
            case 348: {
                return 153;
            }
            case 349: {
                return 154;
            }
            case 351: {
                return 156;
            }
            case 350: {
                return 155;
            }
            case 355: {
                return 158;
            }
            case 352: {
                return 157;
            }
            case 290: {
                return 159;
            }
            case 291: {
                return 160;
            }
            case 293: {
                return 162;
            }
            case 292: {
                return 161;
            }
            case 295: {
                return 164;
            }
            case 294: {
                return 163;
            }
            case 296: {
                return 330;
            }
            case 297: {
                return 331;
            }
            case 298: {
                return 332;
            }
            case 299: {
                return 333;
            }
            case 300: {
                return 334;
            }
            case 301: {
                return 335;
            }
            case 302: {
                return 336;
            }
            case 303: {
                return 337;
            }
            case 304: {
                return 338;
            }
            case 305: {
                return 339;
            }
            case 306: {
                return 340;
            }
            case 307: {
                return 341;
            }
            case 308: {
                return 342;
            }
            case 309: {
                return 343;
            }
            case 310: {
                return 344;
            }
            case 311: {
                return 345;
            }
            case 312: {
                return 346;
            }
            case 313: {
                return 347;
            }
            case 314: {
                return 165;
            }
            case 315: {
                return 166;
            }
            case 316: {
                return 198;
            }
            case 317: {
                return 199;
            }
            case 270: {
                return 153;
            }
        }
        return -1;
    }

    public static int getInvJumpOpcode(int opcode) {
        switch (opcode) {
            case 348: {
                return 154;
            }
            case 349: {
                return 153;
            }
            case 351: {
                return 155;
            }
            case 350: {
                return 156;
            }
            case 355: {
                return 157;
            }
            case 352: {
                return 158;
            }
            case 290: {
                return 160;
            }
            case 291: {
                return 159;
            }
            case 293: {
                return 161;
            }
            case 292: {
                return 162;
            }
            case 295: {
                return 163;
            }
            case 294: {
                return 164;
            }
            case 296: {
                return 331;
            }
            case 297: {
                return 330;
            }
            case 298: {
                return 333;
            }
            case 299: {
                return 332;
            }
            case 300: {
                return 335;
            }
            case 301: {
                return 334;
            }
            case 302: {
                return 337;
            }
            case 303: {
                return 336;
            }
            case 304: {
                return 339;
            }
            case 305: {
                return 338;
            }
            case 306: {
                return 341;
            }
            case 307: {
                return 340;
            }
            case 308: {
                return 343;
            }
            case 309: {
                return 342;
            }
            case 310: {
                return 345;
            }
            case 311: {
                return 344;
            }
            case 312: {
                return 347;
            }
            case 313: {
                return 346;
            }
            case 314: {
                return 166;
            }
            case 315: {
                return 165;
            }
            case 316: {
                return 199;
            }
            case 317: {
                return 198;
            }
            case 270: {
                return 154;
            }
        }
        return -1;
    }
}

