/*
 * Decompiled with CFR 0.152.
 */
package dyvil.reflect;

import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.reflect.ReflectUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

public class ObjectReflection {
    public static String newUnsafeString(char[] values) {
        return ReflectUtils.JAVA_LANG_ACCESS.newStringUnsafe(values);
    }

    public static <T> T createInstance(String className) {
        try {
            Class<?> c = Class.forName(className);
            return (T)c.newInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @DyvilModifiers(value=131080L)
    public static <T> T createInstance(@NonNull Class<T> c) {
        try {
            return c.newInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @DyvilModifiers(value=131080L)
    public static <T> @Nullable T createInstance(@NonNull Class<T> c, Object ... parameters) {
        Class[] parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] == null) continue;
            parameterTypes[i] = parameters[i].getClass();
        }
        return ObjectReflection.createInstance(c, parameterTypes, parameters);
    }

    @DyvilModifiers(value=131080L)
    public static <T> T createInstance(Class<T> c, Class @NonNull [] parameterTypes, Object ... parameters) {
        try {
            Constructor<T> constructor = c.getConstructor(parameterTypes);
            return constructor.newInstance(parameters);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @DyvilModifiers(value=131080L)
    public static <T> T allocateInstance(Class<T> c) {
        try {
            return (T)ReflectUtils.UNSAFE.allocateInstance(c);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @DyvilModifiers(value=131080L)
    public static <T> void copyFields(@NonNull T from, T to) {
        try {
            Class<?> c = from.getClass();
            do {
                for (Field f : c.getDeclaredFields()) {
                    if ((f.getModifiers() & 8) != 0) continue;
                    f.setAccessible(true);
                    f.set(to, f.get(from));
                }
            } while ((c = c.getSuperclass()) != null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

