/*
 * Decompiled with CFR 0.152.
 */
package dyvil.reflect;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class MethodReflection {
    public static final MethodHandles.Lookup LOOKUP;

    public static Method getMethod(@NonNull Class clazz, @NonNull String methodName, @NonNull Class @NonNull [] parameterTypes) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
            if (method != null) {
                return method;
            }
        }
        catch (NoSuchMethodException | SecurityException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static Method getMethod(@NonNull Class clazz, @NonNull String @NonNull [] methodNames, @NonNull Class @NonNull [] parameterTypes) {
        for (String methodName : methodNames) {
            Method method = MethodReflection.getMethod(clazz, methodName, parameterTypes);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public static @NonNull Method getMethod(@NonNull Class clazz, int methodID) {
        return clazz.getDeclaredMethods()[methodID];
    }

    public static <T, R> @Nullable R invokeStatic(@NonNull Class<? super T> clazz, Object @NonNull [] args, int methodID) {
        return MethodReflection.invoke(clazz, null, args, methodID);
    }

    public static <T, R> @Nullable R invoke(@NonNull T instance, Object @NonNull [] args, int methodID) {
        return MethodReflection.invoke(instance.getClass(), instance, args, methodID);
    }

    public static <T, R> @Nullable R invoke(@NonNull Class<? super T> clazz, T instance, Object @NonNull [] args, int methodID) {
        return MethodReflection.invoke(MethodReflection.getMethod(clazz, methodID), instance, args);
    }

    public static <R> R invoke(Method method, Object instance, Object @NonNull [] args) {
        try {
            method.setAccessible(true);
            return (R)method.invoke(instance, args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static {
        MethodHandles.Lookup lookup;
        try {
            Field field = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            field.setAccessible(true);
            lookup = (MethodHandles.Lookup)field.get(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            lookup = null;
        }
        LOOKUP = lookup;
    }
}

