/*
 * Decompiled with CFR 0.152.
 */
package dyvil.reflect;

import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class FieldReflection {
    private static final @Nullable Field modifiersField;

    @DyvilModifiers(value=131080L)
    public static void setModifier(@NonNull Field field, int mod, boolean flag) {
        try {
            field.setAccessible(true);
            int modifiers = field.getModifiers();
            modifiers = flag ? (modifiers |= mod) : (modifiers &= ~mod);
            modifiersField.setInt(field, modifiers);
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
    }

    @DyvilModifiers(value=131080L)
    public static void setAssignable(@NonNull Field field) {
        try {
            field.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T> @NonNull T[] getStaticObjects(@NonNull Class clazz, @NonNull Class<T> fieldType, boolean subtypes) {
        return FieldReflection.getObjects(clazz, null, fieldType, subtypes);
    }

    public static <T> @NonNull T[] getObjects(@NonNull Class clazz, Object instance, @NonNull Class<T> fieldType, boolean subtypes) {
        Field[] fields;
        ArrayList<Object> list = new ArrayList<Object>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            try {
                Class<?> c = field.getType();
                Object o = field.get(instance);
                if (c != fieldType && (!subtypes || !fieldType.isAssignableFrom(c))) continue;
                list.add(o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list.toArray((Object[])Array.newInstance(fieldType, 0));
    }

    public static Field getField(@NonNull Class clazz, @NonNull String name) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public static Field getField(@NonNull Class clazz, String ... fieldNames) {
        Field[] fields = clazz.getDeclaredFields();
        for (String fieldName : fieldNames) {
            for (Field field : fields) {
                if (!fieldName.equals(field.getName())) continue;
                return field;
            }
        }
        return null;
    }

    public static Field getField(@NonNull Class clazz, int fieldID) {
        return clazz.getDeclaredFields()[fieldID];
    }

    public static <T, R> @Nullable R getStaticValue(@NonNull Class<? super T> clazz, String ... fieldNames) {
        return FieldReflection.getValue(clazz, null, fieldNames);
    }

    public static <T, R> @Nullable R getValue(@NonNull T instance, String ... fieldNames) {
        return FieldReflection.getValue(instance.getClass(), instance, fieldNames);
    }

    public static <T, R> @Nullable R getValue(@NonNull Class<? super T> clazz, T instance, String ... fieldNames) {
        Field f = FieldReflection.getField(clazz, fieldNames);
        return FieldReflection.getValue(f, instance);
    }

    public static <T, R> @Nullable R getStaticValue(@NonNull Class<? super T> clazz, int fieldID) {
        return FieldReflection.getValue(clazz, null, fieldID);
    }

    public static <T, R> @Nullable R getValue(@NonNull T instance, int fieldID) {
        return FieldReflection.getValue(instance.getClass(), instance, fieldID);
    }

    public static <T, R> @Nullable R getValue(@NonNull Class<? super T> clazz, T instance, int fieldID) {
        Field f = FieldReflection.getField(clazz, fieldID);
        return FieldReflection.getValue(f, instance);
    }

    public static <R> R getValue(@NonNull Field field, Object instance) {
        try {
            field.setAccessible(true);
            return (R)field.get(instance);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static <T, V> void setStaticValue(@NonNull Class<? super T> clazz, V value, String ... fieldNames) {
        FieldReflection.setValue(clazz, null, value, fieldNames);
    }

    public static <T, V> void setValue(@NonNull T instance, V value, String ... fieldNames) {
        FieldReflection.setValue(instance.getClass(), instance, value, fieldNames);
    }

    public static <T, V> void setValue(@NonNull Class<? super T> clazz, T instance, V value, String ... fieldNames) {
        Field f = FieldReflection.getField(clazz, fieldNames);
        FieldReflection.setField(f, instance, value);
    }

    public static <T, V> void setStaticValue(@NonNull Class<? super T> clazz, V value, int fieldID) {
        FieldReflection.setValue(clazz, null, value, fieldID);
    }

    public static <T, V> void setValue(@NonNull T instance, V value, int fieldID) {
        FieldReflection.setValue(instance.getClass(), instance, value, fieldID);
    }

    public static <T, V> void setValue(@NonNull Class<? super T> clazz, T instance, V value, int fieldID) {
        Field f = FieldReflection.getField(clazz, fieldID);
        FieldReflection.setField(f, instance, value);
    }

    public static <T, V> void setField(@NonNull Field field, T instance, V value) {
        try {
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        Field modField;
        try {
            modField = Field.class.getDeclaredField("modifiers");
            modField.setAccessible(true);
        }
        catch (ReflectiveOperationException ignored) {
            modField = null;
        }
        modifiersField = modField;
    }
}

