/*
 * Decompiled with CFR 0.152.
 */
package dyvil.reflect;

import dyvil.reflect.ReflectUtils;

public class Caller {
    public static Class getCallerClass() {
        try {
            return Class.forName(Caller.getCallerClassName());
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getCallerClassName() {
        return Caller.getCaller().getClassName();
    }

    public static StackTraceElement getCaller() {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        String callerClassName = null;
        for (int i = 1; i < stElements.length; ++i) {
            StackTraceElement ste = stElements[i];
            String className = ste.getClassName();
            if (ReflectUtils.class.getName().equals(className) || className.startsWith("java.lang.Thread")) continue;
            if (callerClassName == null) {
                callerClassName = className;
                continue;
            }
            if (callerClassName.equals(className)) continue;
            return ste;
        }
        return null;
    }
}

