/*
 * Decompiled with CFR 0.152.
 */
package dyvil.ref.unsafe;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.NonNull;
import dyvil.ref.ShortRef;
import dyvil.reflect.ReflectUtils;
import java.lang.reflect.Field;

@ClassParameters(names={"base", "offset"})
public class UnsafeShortRef
implements ShortRef {
    protected final Object base;
    protected final long offset;

    public UnsafeShortRef(@NonNull Field staticField) {
        this(ReflectUtils.UNSAFE.staticFieldBase(staticField), ReflectUtils.UNSAFE.staticFieldOffset(staticField));
    }

    public UnsafeShortRef(Object receiver, @NonNull Field field) {
        this(receiver, ReflectUtils.UNSAFE.objectFieldOffset(field));
    }

    public UnsafeShortRef(Object base, long offset) {
        this.base = base;
        this.offset = offset;
    }

    @Override
    public short get() {
        return ReflectUtils.UNSAFE.getShort(this.base, this.offset);
    }

    @Override
    public void set(short value) {
        ReflectUtils.UNSAFE.putShort(this.base, this.offset, value);
    }
}

