/*
 * Decompiled with CFR 0.152.
 */
package dyvil.ref.unsafe;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.NonNull;
import dyvil.ref.ObjectRef;
import dyvil.reflect.ReflectUtils;
import java.lang.reflect.Field;

@ClassParameters(names={"base", "offset"})
public class UnsafeObjectRef<T>
implements ObjectRef<T> {
    protected final Object base;
    protected final long offset;

    public UnsafeObjectRef(@NonNull Field staticField) {
        this(ReflectUtils.UNSAFE.staticFieldBase(staticField), ReflectUtils.UNSAFE.staticFieldOffset(staticField));
    }

    public UnsafeObjectRef(Object receiver, @NonNull Field field) {
        this(receiver, ReflectUtils.UNSAFE.objectFieldOffset(field));
    }

    public UnsafeObjectRef(Object base, long offset) {
        this.base = base;
        this.offset = offset;
    }

    @Override
    public T get() {
        return (T)ReflectUtils.UNSAFE.getObject(this.base, this.offset);
    }

    @Override
    public void set(T value) {
        ReflectUtils.UNSAFE.putObject(this.base, this.offset, value);
    }
}

