/*
 * Decompiled with CFR 0.152.
 */
package dyvil.ref.unsafe;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.NonNull;
import dyvil.ref.LongRef;
import dyvil.reflect.ReflectUtils;
import java.lang.reflect.Field;

@ClassParameters(names={"base", "offset"})
public class UnsafeLongRef
implements LongRef {
    protected final Object base;
    protected final long offset;

    public UnsafeLongRef(@NonNull Field staticField) {
        this(ReflectUtils.UNSAFE.staticFieldBase(staticField), ReflectUtils.UNSAFE.staticFieldOffset(staticField));
    }

    public UnsafeLongRef(Object receiver, @NonNull Field field) {
        this(receiver, ReflectUtils.UNSAFE.objectFieldOffset(field));
    }

    public UnsafeLongRef(Object base, long offset) {
        this.base = base;
        this.offset = offset;
    }

    @Override
    public long get() {
        return ReflectUtils.UNSAFE.getLong(this.base, this.offset);
    }

    @Override
    public void set(long value) {
        ReflectUtils.UNSAFE.putLong(this.base, this.offset, value);
    }
}

