/*
 * Decompiled with CFR 0.152.
 */
package dyvil.ref.unsafe;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.NonNull;
import dyvil.ref.IntRef;
import dyvil.reflect.ReflectUtils;
import java.lang.reflect.Field;

@ClassParameters(names={"base", "offset"})
public class UnsafeIntRef
implements IntRef {
    protected final Object base;
    protected final long offset;

    public UnsafeIntRef(@NonNull Field staticField) {
        this(ReflectUtils.UNSAFE.staticFieldBase(staticField), ReflectUtils.UNSAFE.staticFieldOffset(staticField));
    }

    public UnsafeIntRef(Object receiver, @NonNull Field field) {
        this(receiver, ReflectUtils.UNSAFE.objectFieldOffset(field));
    }

    public UnsafeIntRef(Object base, long offset) {
        this.base = base;
        this.offset = offset;
    }

    @Override
    public int get() {
        return ReflectUtils.UNSAFE.getInt(this.base, this.offset);
    }

    @Override
    public void set(int value) {
        ReflectUtils.UNSAFE.putInt(this.base, this.offset, value);
    }
}

