/*
 * Decompiled with CFR 0.152.
 */
package dyvil.ref.unsafe;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.NonNull;
import dyvil.ref.FloatRef;
import dyvil.reflect.ReflectUtils;
import java.lang.reflect.Field;

@ClassParameters(names={"base", "offset"})
public class UnsafeFloatRef
implements FloatRef {
    protected final Object base;
    protected final long offset;

    public UnsafeFloatRef(@NonNull Field staticField) {
        this(ReflectUtils.UNSAFE.staticFieldBase(staticField), ReflectUtils.UNSAFE.staticFieldOffset(staticField));
    }

    public UnsafeFloatRef(Object receiver, @NonNull Field field) {
        this(receiver, ReflectUtils.UNSAFE.objectFieldOffset(field));
    }

    public UnsafeFloatRef(Object base, long offset) {
        this.base = base;
        this.offset = offset;
    }

    @Override
    public float get() {
        return ReflectUtils.UNSAFE.getFloat(this.base, this.offset);
    }

    @Override
    public void set(float value) {
        ReflectUtils.UNSAFE.putFloat(this.base, this.offset, value);
    }
}

