/*
 * Decompiled with CFR 0.152.
 */
package dyvil.ref.unsafe;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.NonNull;
import dyvil.ref.DoubleRef;
import dyvil.reflect.ReflectUtils;
import java.lang.reflect.Field;

@ClassParameters(names={"base", "offset"})
public class UnsafeDoubleRef
implements DoubleRef {
    protected final Object base;
    protected final long offset;

    public UnsafeDoubleRef(@NonNull Field staticField) {
        this(ReflectUtils.UNSAFE.staticFieldBase(staticField), ReflectUtils.UNSAFE.staticFieldOffset(staticField));
    }

    public UnsafeDoubleRef(Object receiver, @NonNull Field field) {
        this(receiver, ReflectUtils.UNSAFE.objectFieldOffset(field));
    }

    public UnsafeDoubleRef(Object base, long offset) {
        this.base = base;
        this.offset = offset;
    }

    @Override
    public double get() {
        return ReflectUtils.UNSAFE.getDouble(this.base, this.offset);
    }

    @Override
    public void set(double value) {
        ReflectUtils.UNSAFE.putDouble(this.base, this.offset, value);
    }
}

