/*
 * Decompiled with CFR 0.152.
 */
package dyvil.ref.unsafe;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.NonNull;
import dyvil.ref.CharRef;
import dyvil.reflect.ReflectUtils;
import java.lang.reflect.Field;

@ClassParameters(names={"base", "offset"})
public class UnsafeCharRef
implements CharRef {
    protected final Object base;
    protected final long offset;

    public UnsafeCharRef(@NonNull Field staticField) {
        this(ReflectUtils.UNSAFE.staticFieldBase(staticField), ReflectUtils.UNSAFE.staticFieldOffset(staticField));
    }

    public UnsafeCharRef(Object receiver, @NonNull Field field) {
        this(receiver, ReflectUtils.UNSAFE.objectFieldOffset(field));
    }

    public UnsafeCharRef(Object base, long offset) {
        this.base = base;
        this.offset = offset;
    }

    @Override
    public char get() {
        return ReflectUtils.UNSAFE.getChar(this.base, this.offset);
    }

    @Override
    public void set(char value) {
        ReflectUtils.UNSAFE.putChar(this.base, this.offset, value);
    }
}

