/*
 * Decompiled with CFR 0.152.
 */
package dyvil.ref.unsafe;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.NonNull;
import dyvil.ref.ByteRef;
import dyvil.reflect.ReflectUtils;
import java.lang.reflect.Field;

@ClassParameters(names={"base", "offset"})
public class UnsafeByteRef
implements ByteRef {
    protected final Object base;
    protected final long offset;

    public UnsafeByteRef(@NonNull Field staticField) {
        this(ReflectUtils.UNSAFE.staticFieldBase(staticField), ReflectUtils.UNSAFE.staticFieldOffset(staticField));
    }

    public UnsafeByteRef(Object receiver, @NonNull Field field) {
        this(receiver, ReflectUtils.UNSAFE.objectFieldOffset(field));
    }

    public UnsafeByteRef(Object base, long offset) {
        this.base = base;
        this.offset = offset;
    }

    @Override
    public byte get() {
        return ReflectUtils.UNSAFE.getByte(this.base, this.offset);
    }

    @Override
    public void set(byte value) {
        ReflectUtils.UNSAFE.putByte(this.base, this.offset, value);
    }
}

