/*
 * Decompiled with CFR 0.152.
 */
package dyvil.ref.unsafe;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.NonNull;
import dyvil.ref.BooleanRef;
import dyvil.reflect.ReflectUtils;
import java.lang.reflect.Field;

@ClassParameters(names={"base", "offset"})
public class UnsafeBooleanRef
implements BooleanRef {
    protected final Object base;
    protected final long offset;

    public UnsafeBooleanRef(@NonNull Field staticField) {
        this(ReflectUtils.UNSAFE.staticFieldBase(staticField), ReflectUtils.UNSAFE.staticFieldOffset(staticField));
    }

    public UnsafeBooleanRef(Object receiver, @NonNull Field field) {
        this(receiver, ReflectUtils.UNSAFE.objectFieldOffset(field));
    }

    public UnsafeBooleanRef(Object base, long offset) {
        this.base = base;
        this.offset = offset;
    }

    @Override
    public boolean get() {
        return ReflectUtils.UNSAFE.getBoolean(this.base, this.offset);
    }

    @Override
    public void set(boolean value) {
        ReflectUtils.UNSAFE.putBoolean(this.base, this.offset, value);
    }
}

