/*
 * Decompiled with CFR 0.152.
 */
package dyvil.ref;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.ref.BooleanRef;
import dyvil.ref.ByteRef;
import dyvil.ref.CharRef;
import dyvil.ref.DoubleRef;
import dyvil.ref.FloatRef;
import dyvil.ref.IntRef;
import dyvil.ref.LongRef;
import dyvil.ref.ShortRef;
import dyvil.ref.array.BooleanArrayRef;
import dyvil.ref.array.ByteArrayRef;
import dyvil.ref.array.CharArrayRef;
import dyvil.ref.array.DoubleArrayRef;
import dyvil.ref.array.FloatArrayRef;
import dyvil.ref.array.IntArrayRef;
import dyvil.ref.array.LongArrayRef;
import dyvil.ref.array.ShortArrayRef;
import dyvil.ref.unsafe.UnsafeBooleanRef;
import dyvil.ref.unsafe.UnsafeByteRef;
import dyvil.ref.unsafe.UnsafeCharRef;
import dyvil.ref.unsafe.UnsafeDoubleRef;
import dyvil.ref.unsafe.UnsafeFloatRef;
import dyvil.ref.unsafe.UnsafeIntRef;
import dyvil.ref.unsafe.UnsafeLongRef;
import dyvil.ref.unsafe.UnsafeShortRef;
import dyvil.reflect.ReflectUtils;
import dyvil.runtime.reference.PropertyReferenceMetafactory;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Field;

public final class ReferenceFactory {
    private static final @NonNull MethodType STATIC_CONSTRUCTOR_TYPE;
    private static final @NonNull MethodType INSTANCE_CONSTRUCTOR_TYPE;

    private static @NonNull Field getField(@NonNull Class<? extends @Primitive Object> forType, @NonNull String withName) throws @NonNull NoSuchFieldException {
        Field field = forType.getDeclaredField(withName);
        field.getClass();
        return field;
    }

    public static @NonNull CallSite instanceRefMetafactory(@NonNull MethodHandles.Lookup caller, @NonNull String fieldName, @NonNull MethodType methodType) throws @NonNull Throwable {
        TypeDescriptor.OfField enclosingClass = methodType.parameterType(0);
        TypeDescriptor.OfField targetType = methodType.returnType();
        TypeDescriptor.OfField ofField = enclosingClass;
        ofField.getClass();
        Field field = ReferenceFactory.getField((Class<? extends Object>)ofField, fieldName);
        long offset = ReflectUtils.UNSAFE.objectFieldOffset(field);
        MethodHandle methodHandle = caller.findConstructor((Class<?>)targetType, INSTANCE_CONSTRUCTOR_TYPE);
        methodHandle.getClass();
        MethodHandle constructor = methodHandle;
        return new ConstantCallSite(MethodHandles.insertArguments(constructor, 1, offset).asType(methodType));
    }

    public static @NonNull CallSite staticRefMetafactory(@NonNull MethodHandles.Lookup caller, @NonNull String fieldName, @NonNull MethodType methodType, @NonNull Class<? extends @Primitive Object> enclosingClass) throws @NonNull Throwable {
        TypeDescriptor.OfField targetType = methodType.returnType();
        Field field = ReferenceFactory.getField(enclosingClass, fieldName);
        MethodHandle methodHandle = caller.findConstructor((Class<?>)targetType, STATIC_CONSTRUCTOR_TYPE);
        methodHandle.getClass();
        MethodHandle constructor = methodHandle;
        Object result = constructor.invokeWithArguments(field);
        return new ConstantCallSite(MethodHandles.constant(targetType, result));
    }

    public static @NonNull CallSite propertyRefMetafactory(@NonNull MethodHandles.Lookup caller, @NonNull String invokedName, @NonNull MethodType invokedType, @NonNull MethodHandle getter, @NonNull MethodHandle setter) throws @NonNull Exception {
        return new PropertyReferenceMetafactory(caller, invokedType, getter, setter).buildCallSite();
    }

    public static @NonNull BooleanRef newBooleanRef(@NonNull Object base, long offset) {
        return new UnsafeBooleanRef(base, offset);
    }

    public static @NonNull BooleanRef newBooleanRef(@NonNull Object base, @NonNull Class<? extends @Primitive Object> ofType, @NonNull String field) throws @NonNull NoSuchFieldException {
        return new UnsafeBooleanRef(base, ReferenceFactory.getField(ofType, field));
    }

    public static @NonNull BooleanRef newStaticBooleanRef(@NonNull Class<? extends @Primitive Object> forType, @NonNull String field) throws @NonNull NoSuchFieldException {
        return new UnsafeBooleanRef(ReferenceFactory.getField(forType, field));
    }

    public static @NonNull BooleanRef newBooleanArrayRef(boolean @NonNull [] array, int index) {
        return new BooleanArrayRef(array, index);
    }

    public static @NonNull ByteRef newByteRef(@NonNull Object base, long offset) {
        return new UnsafeByteRef(base, offset);
    }

    public static @NonNull ByteRef newByteRef(@NonNull Object base, @NonNull Class<? extends @Primitive Object> ofType, @NonNull String field) throws @NonNull NoSuchFieldException {
        return new UnsafeByteRef(base, ReferenceFactory.getField(ofType, field));
    }

    public static @NonNull ByteRef newStaticByteRef(@NonNull Class<? extends @Primitive Object> forType, @NonNull String field) throws @NonNull NoSuchFieldException {
        return new UnsafeByteRef(ReferenceFactory.getField(forType, field));
    }

    public static @NonNull ByteRef newByteArrayRef(byte @NonNull [] array, int index) {
        return new ByteArrayRef(array, index);
    }

    public static @NonNull ShortRef newShortRef(@NonNull Object base, long offset) {
        return new UnsafeShortRef(base, offset);
    }

    public static @NonNull ShortRef newShortRef(@NonNull Object base, @NonNull Class<? extends @Primitive Object> ofType, @NonNull String field) throws @NonNull NoSuchFieldException {
        return new UnsafeShortRef(base, ReferenceFactory.getField(ofType, field));
    }

    public static @NonNull ShortRef newStaticShortRef(@NonNull Class<? extends @Primitive Object> forType, @NonNull String field) throws @NonNull NoSuchFieldException {
        return new UnsafeShortRef(ReferenceFactory.getField(forType, field));
    }

    public static @NonNull ShortRef newShortArrayRef(short @NonNull [] array, int index) {
        return new ShortArrayRef(array, index);
    }

    public static @NonNull CharRef newCharRef(@NonNull Object base, long offset) {
        return new UnsafeCharRef(base, offset);
    }

    public static @NonNull CharRef newCharRef(@NonNull Object base, @NonNull Class<? extends @Primitive Object> ofType, @NonNull String field) throws @NonNull NoSuchFieldException {
        return new UnsafeCharRef(base, ReferenceFactory.getField(ofType, field));
    }

    public static @NonNull CharRef newStaticCharRef(@NonNull Class<? extends @Primitive Object> forType, @NonNull String field) throws @NonNull NoSuchFieldException {
        return new UnsafeCharRef(ReferenceFactory.getField(forType, field));
    }

    public static @NonNull CharRef newCharArrayRef(char @NonNull [] array, int index) {
        return new CharArrayRef(array, index);
    }

    public static @NonNull IntRef newIntRef(@NonNull Object base, long offset) {
        return new UnsafeIntRef(base, offset);
    }

    public static @NonNull IntRef newIntRef(@NonNull Object base, @NonNull Class<? extends @Primitive Object> ofType, @NonNull String field) throws @NonNull NoSuchFieldException {
        return new UnsafeIntRef(base, ReferenceFactory.getField(ofType, field));
    }

    public static @NonNull IntRef newStaticIntRef(@NonNull Class<? extends @Primitive Object> forType, @NonNull String field) throws @NonNull NoSuchFieldException {
        return new UnsafeIntRef(ReferenceFactory.getField(forType, field));
    }

    public static @NonNull IntRef newIntArrayRef(int @NonNull [] array, int index) {
        return new IntArrayRef(array, index);
    }

    public static @NonNull LongRef newLongRef(@NonNull Object base, long offset) {
        return new UnsafeLongRef(base, offset);
    }

    public static @NonNull LongRef newLongRef(@NonNull Object base, @NonNull Class<? extends @Primitive Object> ofType, @NonNull String field) throws @NonNull NoSuchFieldException {
        return new UnsafeLongRef(base, ReferenceFactory.getField(ofType, field));
    }

    public static @NonNull LongRef newStaticLongRef(@NonNull Class<? extends @Primitive Object> forType, @NonNull String field) throws @NonNull NoSuchFieldException {
        return new UnsafeLongRef(ReferenceFactory.getField(forType, field));
    }

    public static @NonNull LongRef newLongArrayRef(long @NonNull [] array, int index) {
        return new LongArrayRef(array, index);
    }

    public static @NonNull FloatRef newFloatRef(@NonNull Object base, long offset) {
        return new UnsafeFloatRef(base, offset);
    }

    public static @NonNull FloatRef newFloatRef(@NonNull Object base, @NonNull Class<? extends @Primitive Object> ofType, @NonNull String field) throws @NonNull NoSuchFieldException {
        return new UnsafeFloatRef(base, ReferenceFactory.getField(ofType, field));
    }

    public static @NonNull FloatRef newStaticFloatRef(@NonNull Class<? extends @Primitive Object> forType, @NonNull String field) throws @NonNull NoSuchFieldException {
        return new UnsafeFloatRef(ReferenceFactory.getField(forType, field));
    }

    public static @NonNull FloatRef newFloatArrayRef(float @NonNull [] array, int index) {
        return new FloatArrayRef(array, index);
    }

    public static @NonNull DoubleRef newDoubleRef(@NonNull Object base, long offset) {
        return new UnsafeDoubleRef(base, offset);
    }

    public static @NonNull DoubleRef newDoubleRef(@NonNull Object base, @NonNull Class<? extends @Primitive Object> ofType, @NonNull String field) throws @NonNull NoSuchFieldException {
        return new UnsafeDoubleRef(base, ReferenceFactory.getField(ofType, field));
    }

    public static @NonNull DoubleRef newStaticDoubleRef(@NonNull Class<? extends @Primitive Object> forType, @NonNull String field) throws @NonNull NoSuchFieldException {
        return new UnsafeDoubleRef(ReferenceFactory.getField(forType, field));
    }

    public static @NonNull DoubleRef newDoubleArrayRef(double @NonNull [] array, int index) {
        return new DoubleArrayRef(array, index);
    }

    static {
        MethodType methodType = MethodType.methodType(Void.TYPE, Field.class);
        methodType.getClass();
        STATIC_CONSTRUCTOR_TYPE = methodType;
        MethodType methodType2 = MethodType.methodType(Void.TYPE, Object.class, Long.TYPE);
        methodType2.getClass();
        INSTANCE_CONSTRUCTOR_TYPE = methodType2;
    }
}

