/*
 * Decompiled with CFR 0.152.
 */
package dyvil.random;

import dyvil.annotation.internal.NonNull;
import dyvil.random.JavaRandom;

public interface Random {
    public static @NonNull Random apply() {
        return new JavaRandom();
    }

    public static @NonNull Random apply(long seed) {
        return new JavaRandom(seed);
    }

    public int next(int var1);

    default public boolean nextBoolean() {
        return this.next(1) > 0;
    }

    default public boolean nextBoolean(float f) {
        return !(this.nextFloat() >= f);
    }

    default public byte nextByte() {
        return (byte)this.next(7);
    }

    default public byte nextByte(byte max) {
        return (byte)this.nextInt(max);
    }

    default public byte nextByte(byte min, byte max) {
        return min + this.nextInt(max - min + 1);
    }

    default public short nextShort() {
        return (short)this.next(15);
    }

    default public short nextShort(short max) {
        return (short)this.nextInt(max);
    }

    default public short nextShort(short min, short max) {
        return min + this.nextInt(max - min + 1);
    }

    default public char nextChar() {
        return (char)this.next(16);
    }

    default public char nextChar(char max) {
        return (char)this.nextInt(max);
    }

    default public char nextChar(char min, char max) {
        return min + this.nextInt(max - min + 1);
    }

    default public int nextInt() {
        return this.next(31);
    }

    /*
     * WARNING - void declaration
     */
    default public int nextInt(int max) {
        void var2_2;
        int r = this.next(31);
        int m = max - 1;
        if ((max & m) == 0) {
            return (int)((long)max * (long)r >> 31);
        }
        int u = r;
        while (u - (r = u % max) + m < 0) {
            u = this.next(31);
        }
        return (int)var2_2;
    }

    default public int nextInt(int min, int max) {
        return min + this.nextInt(max - min + 1);
    }

    default public int nextInt(float f) {
        return (int)f + (this.nextFloat() < f ? 0 : 1);
    }

    default public long nextLong() {
        return (long)this.next(31) << 32 | (long)this.next(32);
    }

    /*
     * WARNING - void declaration
     */
    default public long nextLong(long max) {
        void var3_2;
        long r = this.nextLong();
        long m = max - 1L;
        if ((max & m) == 0L) {
            return r & m;
        }
        long u = r >>> 1;
        while (u + m - (r = u % max) < 0L) {
            u = this.nextLong() >>> 1;
        }
        return (long)var3_2;
    }

    default public long nextLong(long min, long max) {
        return min + this.nextLong(max - min + 1L);
    }

    default public float nextFloat() {
        return (float)this.next(24) / (float)(1 << 24);
    }

    default public float nextFloat(float max) {
        return this.nextFloat() * max;
    }

    default public float nextFloat(float min, float max) {
        return min + this.nextFloat() * (max - min);
    }

    default public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) / (double)(1L << 52);
    }

    default public double nextDouble(double max) {
        return this.nextDouble() * max;
    }

    default public double nextDouble(double min, double max) {
        return min + this.nextDouble() * (max - min);
    }

    public double nextGaussian();
}

