/*
 * Decompiled with CFR 0.152.
 */
package dyvil.math.group;

import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.lang.Primitives$Int;
import dyvil.lang.Primitives$Long;
import dyvil.math.PowImpl;
import dyvil.math.group.GroupAdd;
import dyvil.math.group.GroupAddNegate;
import dyvil.math.group.GroupMultiply;
import dyvil.math.group.Ring;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public abstract class GroupImplicits {
    private GroupImplicits() {
    }

    @DyvilModifiers(value=0x210000L)
    public static final class IntGroup
    implements GroupAddNegate<Integer>,
    GroupMultiply<Integer>,
    Serializable {
        @DyvilModifiers(value=0x200000L)
        public static final @NonNull IntGroup instance = new IntGroup();

        public String toString() {
            return "IntGroup";
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public int hashCode() {
            return -1787794535;
        }

        private /* synthetic */ Object readResolve() {
            return instance;
        }

        private /* synthetic */ Object writeReplace() {
            return instance;
        }

        private IntGroup() {
        }

        @Override
        @DyvilName(value="_0")
        public int get_0() {
            return 0;
        }

        @Override
        @DyvilName(value="_1")
        public int get_1() {
            return 1;
        }

        @Override
        public int add(int lhs, int rhs) {
            return lhs + rhs;
        }

        @Override
        public int negate(int rhs) {
            return -rhs;
        }

        @Override
        public int subtract(int lhs, int rhs) {
            return lhs - rhs;
        }

        @Override
        public int multiply(int lhs, int rhs) {
            return lhs * rhs;
        }

        @Override
        public int power(int lhs, int rhs) {
            return Primitives$Int.$times$times(lhs, rhs);
        }
    }

    @DyvilModifiers(value=0x210000L)
    public static final class LongGroup
    implements GroupAddNegate<Long>,
    GroupMultiply<Long>,
    Serializable {
        @DyvilModifiers(value=0x200000L)
        public static final @NonNull LongGroup instance = new LongGroup();

        public String toString() {
            return "LongGroup";
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public int hashCode() {
            return 874809018;
        }

        private /* synthetic */ Object readResolve() {
            return instance;
        }

        private /* synthetic */ Object writeReplace() {
            return instance;
        }

        private LongGroup() {
        }

        @Override
        @DyvilName(value="_0")
        public long get_0() {
            return 0L;
        }

        @Override
        @DyvilName(value="_1")
        public long get_1() {
            return 1L;
        }

        @Override
        public long add(long lhs, long rhs) {
            return lhs + rhs;
        }

        @Override
        public long negate(long rhs) {
            return -rhs;
        }

        @Override
        public long subtract(long lhs, long rhs) {
            return lhs - rhs;
        }

        @Override
        public long multiply(long lhs, long rhs) {
            return lhs * rhs;
        }

        @Override
        public long power(long lhs, int rhs) {
            return Primitives$Long.$times$times(lhs, rhs);
        }
    }

    @DyvilModifiers(value=0x210000L)
    public static final class BigIntegerGroup
    implements GroupAddNegate<BigInteger>,
    GroupMultiply<BigInteger>,
    Serializable {
        @DyvilModifiers(value=0x200000L)
        public static final @NonNull BigIntegerGroup instance = new BigIntegerGroup();

        public String toString() {
            return "BigIntegerGroup";
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public int hashCode() {
            return -529340136;
        }

        private /* synthetic */ Object readResolve() {
            return instance;
        }

        private /* synthetic */ Object writeReplace() {
            return instance;
        }

        private BigIntegerGroup() {
        }

        @Override
        @DyvilName(value="_0")
        public @NonNull BigInteger get_0() {
            BigInteger bigInteger = BigInteger.valueOf(0L);
            bigInteger.getClass();
            return bigInteger;
        }

        @Override
        @DyvilName(value="_1")
        public @NonNull BigInteger get_1() {
            BigInteger bigInteger = BigInteger.valueOf(1L);
            bigInteger.getClass();
            return bigInteger;
        }

        @Override
        public @NonNull BigInteger add(@NonNull BigInteger lhs, @NonNull BigInteger rhs) {
            BigInteger bigInteger = lhs.add(rhs);
            bigInteger.getClass();
            return bigInteger;
        }

        @Override
        public @NonNull BigInteger negate(@NonNull BigInteger rhs) {
            BigInteger bigInteger = rhs.negate();
            bigInteger.getClass();
            return bigInteger;
        }

        @Override
        public @NonNull BigInteger subtract(@NonNull BigInteger lhs, @NonNull BigInteger rhs) {
            BigInteger bigInteger = lhs.subtract(rhs);
            bigInteger.getClass();
            return bigInteger;
        }

        @Override
        public @NonNull BigInteger multiply(@NonNull BigInteger lhs, @NonNull BigInteger rhs) {
            BigInteger bigInteger = lhs.multiply(rhs);
            bigInteger.getClass();
            return bigInteger;
        }

        @Override
        public @NonNull BigInteger power(@NonNull BigInteger lhs, int rhs) {
            BigInteger bigInteger = lhs.pow(rhs);
            bigInteger.getClass();
            return bigInteger;
        }
    }

    @DyvilModifiers(value=0x210000L)
    public static final class DoubleRing
    implements Ring<Double>,
    Serializable {
        @DyvilModifiers(value=0x200000L)
        public static final @NonNull DoubleRing instance = new DoubleRing();

        public String toString() {
            return "DoubleRing";
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public int hashCode() {
            return -1154966742;
        }

        private /* synthetic */ Object readResolve() {
            return instance;
        }

        private /* synthetic */ Object writeReplace() {
            return instance;
        }

        private DoubleRing() {
        }

        @Override
        @DyvilName(value="_0")
        public double get_0() {
            return 0.0;
        }

        @Override
        @DyvilName(value="_1")
        public double get_1() {
            return 1.0;
        }

        @Override
        public double add(double lhs, double rhs) {
            return lhs + rhs;
        }

        @Override
        public double negate(double rhs) {
            return -rhs;
        }

        @Override
        public double subtract(double lhs, double rhs) {
            return lhs - rhs;
        }

        @Override
        public double multiply(double lhs, double rhs) {
            return lhs * rhs;
        }

        @Override
        public double inverse(double rhs) {
            return 1.0 / rhs;
        }

        @Override
        public double divide(double lhs, double rhs) {
            return lhs / rhs;
        }

        @Override
        public double power(double lhs, int rhs) {
            return Math.pow(lhs, rhs);
        }
    }

    @DyvilModifiers(value=0x210000L)
    public static final class FloatRing
    implements Ring<Float>,
    Serializable {
        @DyvilModifiers(value=0x200000L)
        public static final @NonNull FloatRing instance = new FloatRing();

        public String toString() {
            return "FloatRing";
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public int hashCode() {
            return -1342501885;
        }

        private /* synthetic */ Object readResolve() {
            return instance;
        }

        private /* synthetic */ Object writeReplace() {
            return instance;
        }

        private FloatRing() {
        }

        @Override
        @DyvilName(value="_0")
        public float get_0() {
            return 0.0f;
        }

        @Override
        @DyvilName(value="_1")
        public float get_1() {
            return 1.0f;
        }

        @Override
        public float add(float lhs, float rhs) {
            return lhs + rhs;
        }

        @Override
        public float negate(float rhs) {
            return -rhs;
        }

        @Override
        public float subtract(float lhs, float rhs) {
            return lhs - rhs;
        }

        @Override
        public float multiply(float lhs, float rhs) {
            return lhs * rhs;
        }

        @Override
        public float inverse(float rhs) {
            return 1.0f / rhs;
        }

        @Override
        public float divide(float lhs, float rhs) {
            return lhs / rhs;
        }

        @Override
        public float power(float lhs, int rhs) {
            return (float)Math.pow(lhs, rhs);
        }
    }

    @DyvilModifiers(value=0x210000L)
    public static final class BigDecimalRing
    implements Ring<BigDecimal>,
    Serializable {
        @DyvilModifiers(value=0x200000L)
        public static final @NonNull BigDecimalRing instance = new BigDecimalRing();

        public String toString() {
            return "BigDecimalRing";
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public int hashCode() {
            return 1961398538;
        }

        private /* synthetic */ Object readResolve() {
            return instance;
        }

        private /* synthetic */ Object writeReplace() {
            return instance;
        }

        private BigDecimalRing() {
        }

        @Override
        @DyvilName(value="_0")
        public @NonNull BigDecimal get_0() {
            BigDecimal bigDecimal = BigDecimal.ZERO;
            bigDecimal.getClass();
            return bigDecimal;
        }

        @Override
        @DyvilName(value="_1")
        public @NonNull BigDecimal get_1() {
            BigDecimal bigDecimal = BigDecimal.ONE;
            bigDecimal.getClass();
            return bigDecimal;
        }

        @Override
        public @NonNull BigDecimal add(@NonNull BigDecimal lhs, @NonNull BigDecimal rhs) {
            BigDecimal bigDecimal = lhs.add(rhs);
            bigDecimal.getClass();
            return bigDecimal;
        }

        @Override
        public @NonNull BigDecimal negate(@NonNull BigDecimal rhs) {
            BigDecimal bigDecimal = rhs.negate();
            bigDecimal.getClass();
            return bigDecimal;
        }

        @Override
        public @NonNull BigDecimal subtract(@NonNull BigDecimal lhs, @NonNull BigDecimal rhs) {
            BigDecimal bigDecimal = lhs.subtract(rhs);
            bigDecimal.getClass();
            return bigDecimal;
        }

        @Override
        public @NonNull BigDecimal multiply(@NonNull BigDecimal lhs, @NonNull BigDecimal rhs) {
            BigDecimal bigDecimal = lhs.multiply(rhs);
            bigDecimal.getClass();
            return bigDecimal;
        }

        @Override
        public @NonNull BigDecimal inverse(@NonNull BigDecimal rhs) {
            BigDecimal bigDecimal = BigDecimal.ONE.divide(rhs, RoundingMode.HALF_EVEN);
            bigDecimal.getClass();
            return bigDecimal;
        }

        @Override
        public @NonNull BigDecimal divide(@NonNull BigDecimal lhs, @NonNull BigDecimal rhs) {
            BigDecimal bigDecimal = lhs.divide(rhs, RoundingMode.HALF_EVEN);
            bigDecimal.getClass();
            return bigDecimal;
        }

        @Override
        public @NonNull BigDecimal power(@NonNull BigDecimal lhs, int rhs) {
            BigDecimal bigDecimal = PowImpl.pow(lhs, rhs);
            bigDecimal.getClass();
            return bigDecimal;
        }
    }

    @DyvilModifiers(value=0x210000L)
    public static final class StringGroup
    implements GroupAdd<String>,
    Serializable {
        @DyvilModifiers(value=0x200000L)
        public static final @NonNull StringGroup instance = new StringGroup();

        public String toString() {
            return "StringGroup";
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public int hashCode() {
            return -1346721659;
        }

        private /* synthetic */ Object readResolve() {
            return instance;
        }

        private /* synthetic */ Object writeReplace() {
            return instance;
        }

        private StringGroup() {
        }

        @Override
        @DyvilName(value="_0")
        public @NonNull String get_0() {
            return "";
        }

        @Override
        public @NonNull String add(@NonNull String lhs, @NonNull String rhs) {
            return lhs.concat(rhs);
        }
    }
}

