/*
 * Decompiled with CFR 0.152.
 */
package dyvil.math;

import dyvil.annotation.Experimental;
import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.lang.Formattable;
import dyvil.lang.LiteralConvertible;
import dyvil.lang.Primitives$Long;
import dyvil.math.group.RingCompatible;

@LiteralConvertible.FromInt
@LiteralConvertible.FromLong
@ClassParameters(names={"numerator", "denominator"})
public class Rational
implements RingCompatible<Rational>,
Formattable,
Comparable<Rational> {
    protected final long numerator;
    protected final long denominator;
    public static final @NonNull Rational _0 = Rational.apply(0L);
    public static final @NonNull Rational _1 = Rational.apply(1L);

    @DyvilName(value="numerator")
    public long getNumerator() {
        return this.numerator;
    }

    @DyvilName(value="denominator")
    public long getDenominator() {
        return this.denominator;
    }

    @DyvilName(value="_0")
    public static @NonNull Rational get_0() {
        return _0;
    }

    public static /* bridge */ /* synthetic */ RingCompatible get_0() {
        return Rational.get_0();
    }

    @DyvilName(value="_1")
    public static @NonNull Rational get_1() {
        return _1;
    }

    public static /* bridge */ /* synthetic */ RingCompatible get_1() {
        return Rational.get_1();
    }

    private Rational(long numerator, long denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public static long gcd(long a, long b) {
        long l;
        while (b != 0L) {
            long t = b;
            b = a % b;
            a = t;
        }
        return l;
    }

    public static @NonNull Rational apply(long numerator) {
        return new Rational(numerator, 1L);
    }

    public static @NonNull Rational apply(long numerator, long denominator) {
        if (numerator == 0L) {
            return _0;
        }
        long gcd = Rational.gcd(numerator, denominator);
        numerator /= gcd;
        if ((denominator /= gcd) < 0L) {
            numerator = -numerator;
            denominator = -denominator;
        }
        return new Rational(numerator, denominator);
    }

    @Experimental
    public static @NonNull Rational apply(@DyvilModifiers(value=0x400000L) double d) {
        long mant;
        long bits = Double.doubleToLongBits(d);
        int sign = bits >>> 63 == 0L ? 1 : -1;
        int e = (int)(bits >> 52) & 0x7FF;
        int exp = e - 1075;
        long m = bits & 0xFFFFFFFFFFFFFL;
        long l = mant = e == 0 ? m << 1 : m | 0x10000000000000L;
        if (exp > 0) {
            mant <<= exp;
            exp = 0;
        }
        return Rational.apply((long)sign * mant, 1L << -exp);
    }

    public static @NonNull Rational $plus(@NonNull Rational rhs) {
        return rhs;
    }

    public static /* bridge */ /* synthetic */ RingCompatible $plus(RingCompatible ringCompatible) {
        return Rational.$plus((Rational)ringCompatible);
    }

    public static @NonNull Rational $minus(@NonNull Rational rhs) {
        return new Rational(-rhs.numerator, rhs.denominator);
    }

    public static /* bridge */ /* synthetic */ RingCompatible $minus(RingCompatible ringCompatible) {
        return Rational.$minus((Rational)ringCompatible);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Rational inverse(@NonNull Rational lhs) {
        return Rational.apply(lhs.denominator, lhs.numerator);
    }

    public static /* bridge */ /* synthetic */ RingCompatible inverse(RingCompatible ringCompatible) {
        return Rational.inverse((Rational)ringCompatible);
    }

    public static @NonNull Rational $bar_$bar(@NonNull Rational r) {
        Rational rational;
        return r.numerator < 0L ? Rational.$minus(r) : rational;
    }

    public float toFloat() {
        return (float)this.toDouble();
    }

    public double toDouble() {
        return (double)this.numerator / (double)this.denominator;
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Rational $plus(@NonNull Rational lhs, @NonNull Rational rhs) {
        long lhsDenom = lhs.denominator;
        long rhsDenom = rhs.denominator;
        long num = lhs.numerator * rhsDenom + rhs.numerator * lhsDenom;
        long denom = lhsDenom * rhsDenom;
        return Rational.apply(num, denom);
    }

    public static /* bridge */ /* synthetic */ RingCompatible $plus(RingCompatible ringCompatible, RingCompatible ringCompatible2) {
        return Rational.$plus((Rational)ringCompatible, (Rational)ringCompatible2);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Rational $minus(@NonNull Rational lhs, @NonNull Rational rhs) {
        return Rational.$plus(lhs, Rational.$minus(rhs));
    }

    public static /* bridge */ /* synthetic */ RingCompatible $minus(RingCompatible ringCompatible, RingCompatible ringCompatible2) {
        return Rational.$minus((Rational)ringCompatible, (Rational)ringCompatible2);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Rational $times(@NonNull Rational lhs, @NonNull Rational rhs) {
        long num = lhs.numerator * rhs.numerator;
        long denom = lhs.denominator * rhs.denominator;
        return Rational.apply(num, denom);
    }

    public static /* bridge */ /* synthetic */ RingCompatible $times(RingCompatible ringCompatible, RingCompatible ringCompatible2) {
        return Rational.$times((Rational)ringCompatible, (Rational)ringCompatible2);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Rational $div(@NonNull Rational lhs, @NonNull Rational rhs) {
        long num = lhs.numerator * rhs.denominator;
        long denom = lhs.denominator * rhs.numerator;
        return Rational.apply(num, denom);
    }

    public static /* bridge */ /* synthetic */ RingCompatible $div(RingCompatible ringCompatible, RingCompatible ringCompatible2) {
        return Rational.$div((Rational)ringCompatible, (Rational)ringCompatible2);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Rational $times$times(@NonNull Rational lhs, int rhs) {
        return Rational.apply(Primitives$Long.$times$times(lhs.numerator, rhs), Primitives$Long.$times$times(lhs.denominator, rhs));
    }

    public static /* bridge */ /* synthetic */ RingCompatible $times$times(RingCompatible ringCompatible, int n) {
        return Rational.$times$times((Rational)ringCompatible, n);
    }

    public boolean equals(@Primitive Object obj) {
        return this == obj || obj instanceof Rational && this.equals((Rational)obj);
    }

    public boolean equals(@NonNull Rational that) {
        return this == that || this.numerator == that.numerator && this.denominator == that.denominator;
    }

    public int hashCode() {
        long l = this.numerator;
        long l2 = this.denominator;
        return (int)(l ^ l >>> 32) * 31 + (int)(l2 ^ l2 >>> 32);
    }

    @Override
    public int compareTo(@NonNull Rational that) {
        return Long.valueOf(this.numerator * that.denominator).compareTo(that.numerator * this.denominator);
    }

    public @NonNull String toString() {
        return Formattable.format(this);
    }

    @Override
    public void toString(@NonNull StringBuilder buffer) {
        buffer.append(this.numerator).append(" / ").append(this.denominator);
    }
}

