/*
 * Decompiled with CFR 0.152.
 */
package dyvil.math;

import dyvil.annotation.internal.NonNull;
import java.math.BigDecimal;
import java.math.RoundingMode;

public final class PowImpl {
    private static final byte[] HIGHEST_SET_BIT = new byte[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6};

    private PowImpl() {
    }

    public static long pow(long base, int exponent) {
        if (base == 0L) {
            if (exponent <= 0) {
                throw new ArithmeticException("0 ** " + exponent);
            }
            return 0L;
        }
        if (base == 1L) {
            return 1L;
        }
        if (base == -1L) {
            return 1 - ((exponent & 1) << 1);
        }
        if (exponent < 0) {
            return 0L;
        }
        if (exponent > 63) {
            return PowImpl.powRec(base, exponent);
        }
        long result = 1L;
        switch (HIGHEST_SET_BIT[exponent]) {
            case 6: {
                if ((exponent & 1) != 0) {
                    result *= base;
                }
                exponent >>= 1;
                base *= base;
            }
            case 5: {
                if ((exponent & 1) != 0) {
                    result *= base;
                }
                exponent >>= 1;
                base *= base;
            }
            case 4: {
                if ((exponent & 1) != 0) {
                    result *= base;
                }
                exponent >>= 1;
                base *= base;
            }
            case 3: {
                if ((exponent & 1) != 0) {
                    result *= base;
                }
                exponent >>= 1;
                base *= base;
            }
            case 2: {
                if ((exponent & 1) != 0) {
                    result *= base;
                }
                exponent >>= 1;
                base *= base;
            }
            case 1: {
                if ((exponent & 1) == 0) break;
                result *= base;
            }
        }
        return result;
    }

    private static long powRec(long base, int exponent) {
        switch (exponent) {
            case 0: {
                return 1L;
            }
            case 1: {
                return base;
            }
        }
        return ((exponent & 1) == 0 ? 1L : base) * PowImpl.powRec(base * base, exponent >> 1);
    }

    public static BigDecimal pow(@NonNull BigDecimal base, int exponent) {
        if (exponent < 0) {
            return BigDecimal.ONE.divide(base.pow(-exponent), RoundingMode.HALF_EVEN);
        }
        return base.pow(exponent);
    }

    public static BigDecimal pow(@NonNull BigDecimal base, double exponent) {
        boolean negativeExponent;
        if (exponent < 0.0) {
            negativeExponent = true;
            exponent = -exponent;
        } else {
            negativeExponent = false;
        }
        double exponentRemainder = exponent % 1.0;
        int exponentInt = (int)(exponent - exponentRemainder);
        BigDecimal intPow = base.pow(exponentInt);
        BigDecimal doublePow = new BigDecimal(Math.pow(base.doubleValue(), exponentRemainder));
        BigDecimal result = intPow.multiply(doublePow);
        if (negativeExponent) {
            return BigDecimal.ONE.divide(result, RoundingMode.HALF_EVEN);
        }
        return result;
    }

    public static BigDecimal pow(@NonNull BigDecimal base, @NonNull BigDecimal exponent) {
        int exponentSign = exponent.signum();
        if (exponentSign < 0) {
            exponent = exponent.negate();
        }
        BigDecimal exponentRemainder = exponent.remainder(BigDecimal.ONE);
        BigDecimal exponentInt = exponent.subtract(exponentRemainder);
        BigDecimal intPow = base.pow(exponentInt.intValueExact());
        BigDecimal doublePow = new BigDecimal(Math.pow(base.doubleValue(), exponentRemainder.doubleValue()));
        BigDecimal result = intPow.multiply(doublePow);
        if (exponentSign < 0) {
            return BigDecimal.ONE.divide(result, RoundingMode.HALF_EVEN);
        }
        return result;
    }
}

