/*
 * Decompiled with CFR 0.152.
 */
package dyvil.math;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.array.DoubleArray;
import dyvil.function.Function;
import dyvil.lang.Formattable;
import dyvil.lang.LiteralConvertible;
import dyvil.math.group.RingCompatible;
import dyvil.runtime.LambdaMetafactory;
import dyvil.tuple.Tuple;

@LiteralConvertible.FromInt
@LiteralConvertible.FromLong
@LiteralConvertible.FromFloat
@LiteralConvertible.FromDouble
@ClassParameters(names={"coefficients"})
public class Polynomial
implements RingCompatible<Polynomial>,
Formattable,
Function.Of1<Double, Double> {
    protected double @NonNull [] coefficients;
    public static final @NonNull Polynomial _0 = new Polynomial(new double[0]);
    public static final @NonNull Polynomial _1 = new Polynomial(new double[]{1.0});
    public static final @NonNull Polynomial _x = new Polynomial(new double[]{0.0, 1.0});

    private static double lambda$0(double d, double d2) {
        return d * d2;
    }

    private static double lambda$1(double d, double d2) {
        return d2 * d;
    }

    private static double lambda$2(double d, double d2) {
        return d2 / d;
    }

    @DyvilName(value="_0")
    public static @NonNull Polynomial get_0() {
        return _0;
    }

    public static /* bridge */ /* synthetic */ RingCompatible get_0() {
        return Polynomial.get_0();
    }

    @DyvilName(value="_1")
    public static @NonNull Polynomial get_1() {
        return _1;
    }

    public static /* bridge */ /* synthetic */ RingCompatible get_1() {
        return Polynomial.get_1();
    }

    private Polynomial(double @NonNull [] coefficients) {
        this.coefficients = coefficients;
    }

    @DyvilName(value="degree")
    public int getDegree() {
        return this.coefficients.length - 1;
    }

    @DyvilName(value="apply")
    public static @NonNull Polynomial apply0(double coefficient) {
        return Polynomial.apply(coefficient, 0);
    }

    public static @NonNull Polynomial apply(double ... coefficients) {
        for (int i = coefficients.length - 1; i >= 0; --i) {
            if (coefficients[i] == 0.0) continue;
            return new Polynomial(DoubleArray.trim(coefficients, i + 1));
        }
        return _0;
    }

    public static @NonNull Polynomial apply(double coefficient, @DyvilModifiers(value=0x400000L) int degree) {
        if (coefficient == 0.0) {
            return _0;
        }
        double[] array = new double[degree + 1];
        array[degree] = coefficient;
        return new Polynomial(array);
    }

    public double subscript(int index) {
        return this.coefficients[index];
    }

    public boolean isZero() {
        return this.coefficients.length == 0;
    }

    @Override
    public double apply(double x) {
        double xpow = 1.0;
        double sum = 0.0;
        double[] dArray = this.coefficients;
        int n = dArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                double c = dArray[n2];
                sum += c * xpow;
                xpow *= x;
            } while (++n2 < n);
        }
        return sum;
    }

    public @NonNull Polynomial differentiate() {
        if (this.getDegree() <= 0) {
            return _0;
        }
        double[] oldCoeff = this.coefficients;
        double[] newCoeff = DoubleArray.apply(oldCoeff.length - 1);
        int n = oldCoeff.length;
        for (int i = 1; i < n; ++i) {
            newCoeff[i - 1] = oldCoeff[i] * (double)i;
        }
        return new Polynomial(newCoeff);
    }

    public @NonNull Polynomial integrate() {
        if (this.isZero()) {
            return _0;
        }
        double[] oldCoeff = this.coefficients;
        double[] newCoeff = DoubleArray.apply(oldCoeff.length + 1);
        int n = oldCoeff.length;
        for (int i = 0; i < n; ++i) {
            newCoeff[i + 1] = oldCoeff[i] / (double)(i + 1);
        }
        return new Polynomial(newCoeff);
    }

    @DyvilModifiers(value=131072L)
    private static @NonNull Polynomial mapped(@NonNull Polynomial poly, @NonNull Function.Of1<@Primitive Double, @Primitive Double> op) {
        double[] oldCoeff = poly.coefficients;
        int size = oldCoeff.length;
        double[] newCoeff = new double[size];
        int n = size;
        for (int i = 0; i < n; ++i) {
            newCoeff[i] = op.apply(oldCoeff[i]);
        }
        return Polynomial.apply(newCoeff);
    }

    public static @NonNull Polynomial $plus(@NonNull Polynomial rhs) {
        return rhs;
    }

    public static /* bridge */ /* synthetic */ RingCompatible $plus(RingCompatible ringCompatible) {
        return Polynomial.$plus((Polynomial)ringCompatible);
    }

    public static @NonNull Polynomial $minus(@NonNull Polynomial rhs) {
        return Polynomial.mapped(rhs, (Function.Of1<double, double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $minus(double ), (D)D)());
    }

    public static /* bridge */ /* synthetic */ RingCompatible $minus(RingCompatible ringCompatible) {
        return Polynomial.$minus((Polynomial)ringCompatible);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Polynomial inverse(@NonNull Polynomial lhs) {
        throw new UnsupportedOperationException("reciprocal of polynomial");
    }

    public static /* bridge */ /* synthetic */ RingCompatible inverse(RingCompatible ringCompatible) {
        return Polynomial.inverse((Polynomial)ringCompatible);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Polynomial $plus(@NonNull Polynomial lhs, @NonNull Polynomial rhs) {
        Polynomial polynomial;
        double[] lhsCoeff = lhs.coefficients;
        double[] rhsCoeff = rhs.coefficients;
        if (lhsCoeff.length > rhsCoeff.length) {
            double[] coeff = DoubleArray.copy(lhsCoeff);
            int n = rhsCoeff.length;
            for (int i = 0; i < n; ++i) {
                coeff[i] = coeff[i] + rhsCoeff[i];
            }
            polynomial = Polynomial.apply(coeff);
        } else {
            double[] coeff = DoubleArray.copy(rhsCoeff);
            int n = lhsCoeff.length;
            for (int i = 0; i < n; ++i) {
                coeff[i] = coeff[i] + lhsCoeff[i];
            }
            polynomial = Polynomial.apply(coeff);
        }
        return polynomial;
    }

    public static /* bridge */ /* synthetic */ RingCompatible $plus(RingCompatible ringCompatible, RingCompatible ringCompatible2) {
        return Polynomial.$plus((Polynomial)ringCompatible, (Polynomial)ringCompatible2);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Polynomial $minus(@NonNull Polynomial lhs, @NonNull Polynomial rhs) {
        return Polynomial.$plus(lhs, Polynomial.$minus(rhs));
    }

    public static /* bridge */ /* synthetic */ RingCompatible $minus(RingCompatible ringCompatible, RingCompatible ringCompatible2) {
        return Polynomial.$minus((Polynomial)ringCompatible, (Polynomial)ringCompatible2);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Polynomial $times(double lhs, @NonNull Polynomial rhs) {
        return Polynomial.mapped(rhs, (Function.Of1<double, double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$0(double double ), (D)D)((double)lhs));
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Polynomial $times(@NonNull Polynomial lhs, double rhs) {
        return Polynomial.mapped(lhs, (Function.Of1<double, double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$1(double double ), (D)D)((double)rhs));
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Polynomial $times(@NonNull Polynomial lhs, @NonNull Polynomial rhs) {
        double[] lhsCoeff = lhs.coefficients;
        int lhsSize = lhsCoeff.length;
        double[] rhsCoeff = rhs.coefficients;
        int rhsSize = rhsCoeff.length;
        double[] coeff = new double[lhsSize + rhsSize - 1];
        int n = lhsCoeff.length;
        for (int i = 0; i < n; ++i) {
            int n2 = rhsCoeff.length;
            for (int j = 0; j < n2; ++j) {
                int sideEffect$0 = i + j;
                coeff[sideEffect$0] = coeff[sideEffect$0] + lhsCoeff[i] * rhsCoeff[j];
            }
        }
        return Polynomial.apply(coeff);
    }

    public static /* bridge */ /* synthetic */ RingCompatible $times(RingCompatible ringCompatible, RingCompatible ringCompatible2) {
        return Polynomial.$times((Polynomial)ringCompatible, (Polynomial)ringCompatible2);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Polynomial $div(@NonNull Polynomial lhs, double rhs) {
        return Polynomial.mapped(lhs, (Function.Of1<double, double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$2(double double ), (D)D)((double)rhs));
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Polynomial $div(@NonNull Polynomial lhs, @NonNull Polynomial rhs) {
        return Polynomial.$div$percent(lhs, rhs).get_1();
    }

    public static /* bridge */ /* synthetic */ RingCompatible $div(RingCompatible ringCompatible, RingCompatible ringCompatible2) {
        return Polynomial.$div((Polynomial)ringCompatible, (Polynomial)ringCompatible2);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Polynomial $percent(@NonNull Polynomial lhs, @NonNull Polynomial rhs) {
        return Polynomial.$div$percent(lhs, rhs).get_2();
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Tuple.Of2<@NonNull Polynomial, @NonNull Polynomial> $div$percent(@NonNull Polynomial n, @NonNull Polynomial d) {
        if (d.isZero()) {
            throw new ArithmeticException("division by zero polynomial");
        }
        Polynomial q = _0;
        Polynomial r = n;
        while (!r.isZero() && r.getDegree() >= d.getDegree()) {
            Polynomial t = Polynomial.divideHigh(r, d);
            q = Polynomial.$plus(q, t);
            r = Polynomial.$minus(r, Polynomial.$times(t, d));
        }
        return new Tuple.Of2<Polynomial, Polynomial>(q, r);
    }

    private static @NonNull Polynomial divideHigh(@NonNull Polynomial r, @NonNull Polynomial d) {
        int rDeg = r.getDegree();
        double rCoeff = r.coefficients[rDeg];
        int dDeg = d.getDegree();
        double dCoeff = d.coefficients[dDeg];
        return Polynomial.apply(rCoeff / dCoeff, rDeg - dDeg);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Polynomial $times$times(@NonNull Polynomial lhs, int rhs) {
        if (rhs < 0) {
            throw new UnsupportedOperationException("polynomial to the negative power");
        }
        if (rhs == 0) {
            return _1;
        }
        if (rhs == 1) {
            return lhs;
        }
        return (rhs & 1) == 0 ? Polynomial.$times$times(Polynomial.$times(lhs, lhs), rhs >> 1) : Polynomial.$times(lhs, Polynomial.$times$times(Polynomial.$times(lhs, lhs), rhs >> 1));
    }

    public static /* bridge */ /* synthetic */ RingCompatible $times$times(RingCompatible ringCompatible, int n) {
        return Polynomial.$times$times((Polynomial)ringCompatible, n);
    }

    public static @NonNull Polynomial gcd(@NonNull Polynomial a, @NonNull Polynomial b) {
        Polynomial polynomial;
        while (!b.isZero()) {
            Polynomial t = b;
            b = Polynomial.$percent(a, b);
            a = t;
        }
        return polynomial;
    }

    public boolean equals(@Primitive Object obj) {
        return this == obj || obj instanceof Polynomial && this.equals((Polynomial)obj);
    }

    public boolean equals(@NonNull Polynomial that) {
        return this == that || DoubleArray.$eq$eq(this.coefficients, that.coefficients);
    }

    public int hashCode() {
        return DoubleArray.hashCode(this.coefficients);
    }

    public @NonNull String toString() {
        return Formattable.format(this);
    }

    @Override
    public void toString(@NonNull StringBuilder buffer) {
        int size = this.coefficients.length;
        if (size == 0) {
            buffer.append("0.0");
            return;
        }
        if (size == 1) {
            buffer.append(this.coefficients[0]);
            return;
        }
        double coeff = this.coefficients[0];
        if (coeff != 0.0) {
            buffer.append(coeff).append(" + ");
        }
        int n = size - 2;
        for (int i = 1; i <= n; ++i) {
            coeff = this.coefficients[i];
            if (coeff == 0.0) continue;
            Polynomial.toString(coeff, i, buffer);
            buffer.append(" + ");
        }
        Polynomial.toString(this.coefficients[size - 1], size - 1, buffer);
    }

    private static void toString(double coefficient, int degree, @NonNull StringBuilder buffer) {
        buffer.append(coefficient).append(" x^").append(degree);
    }
}

