/*
 * Decompiled with CFR 0.152.
 */
package dyvil.math;

import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.ReceiverType;
import dyvil.array.ObjectArray;
import dyvil.function.Function;
import dyvil.math.DeBruijn;
import dyvil.math.group.GroupAdd;
import dyvil.math.group.GroupMultiply;
import dyvil.math.group.GroupOperators;

@DyvilModifiers(value=262144L)
@DyvilName(value="extension_Ljava_lang_Math__")
public class MathUtils {
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static int min(int a, int b, int c) {
        return MathUtils.min(a, MathUtils.min(b, c));
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static int min(int ... values) {
        void var1_1;
        int min = Integer.MAX_VALUE;
        int[] nArray = values;
        int n = nArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                int v;
                if ((v = nArray[n2]) >= min) continue;
                min = v;
            } while (++n2 < n);
        }
        return (int)var1_1;
    }

    @DyvilModifiers(value=327688L)
    @DyvilName(value="min")
    @ReceiverType(value="Ljava/lang/Math;")
    public static int min$_array(int @NonNull [] array) {
        return MathUtils.min(array);
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static long min(long a, long b, long c) {
        return MathUtils.min(a, MathUtils.min(b, c));
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static long min(long ... values) {
        void var1_1;
        long min = Long.MAX_VALUE;
        long[] lArray = values;
        int n = lArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                long v;
                if ((v = lArray[n2]) >= min) continue;
                min = v;
            } while (++n2 < n);
        }
        return (long)var1_1;
    }

    @DyvilModifiers(value=327688L)
    @DyvilName(value="min")
    @ReceiverType(value="Ljava/lang/Math;")
    public static long min$_array(long @NonNull [] array) {
        return MathUtils.min(array);
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static float min(float a, float b, float c) {
        return MathUtils.min(a, MathUtils.min(b, c));
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static float min(float ... values) {
        void var1_1;
        float min = Float.POSITIVE_INFINITY;
        float[] fArray = values;
        int n = fArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                float v;
                if (!((v = fArray[n2]) < min)) continue;
                min = v;
            } while (++n2 < n);
        }
        return (float)var1_1;
    }

    @DyvilModifiers(value=327688L)
    @DyvilName(value="min")
    @ReceiverType(value="Ljava/lang/Math;")
    public static float min$_array(float @NonNull [] array) {
        return MathUtils.min(array);
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static double min(double a, double b, double c) {
        return MathUtils.min(a, MathUtils.min(b, c));
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static double min(double ... values) {
        void var1_1;
        double min = Double.POSITIVE_INFINITY;
        double[] dArray = values;
        int n = dArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                double v;
                if (!((v = dArray[n2]) < min)) continue;
                min = v;
            } while (++n2 < n);
        }
        return (double)var1_1;
    }

    @DyvilModifiers(value=327688L)
    @DyvilName(value="min")
    @ReceiverType(value="Ljava/lang/Math;")
    public static double min$_array(double @NonNull [] array) {
        return MathUtils.min(array);
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static int max(int a, int b, int c) {
        return MathUtils.max(a, MathUtils.max(b, c));
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static int max(int ... values) {
        void var1_1;
        int max = Integer.MIN_VALUE;
        int[] nArray = values;
        int n = nArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                int v;
                if ((v = nArray[n2]) <= max) continue;
                max = v;
            } while (++n2 < n);
        }
        return (int)var1_1;
    }

    @DyvilModifiers(value=327688L)
    @DyvilName(value="max")
    @ReceiverType(value="Ljava/lang/Math;")
    public static int max$_array(int @NonNull [] array) {
        return MathUtils.max(array);
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static long max(long a, long b, long c) {
        return MathUtils.max(a, MathUtils.max(b, c));
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static long max(long ... values) {
        void var1_1;
        long max = Long.MIN_VALUE;
        long[] lArray = values;
        int n = lArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                long v;
                if ((v = lArray[n2]) <= max) continue;
                max = v;
            } while (++n2 < n);
        }
        return (long)var1_1;
    }

    @DyvilModifiers(value=327688L)
    @DyvilName(value="max")
    @ReceiverType(value="Ljava/lang/Math;")
    public static long max$_array(long @NonNull [] array) {
        return MathUtils.max(array);
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static float max(float a, float b, float c) {
        return MathUtils.max(a, MathUtils.max(b, c));
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static float max(float ... values) {
        void var1_1;
        float max = Float.NEGATIVE_INFINITY;
        float[] fArray = values;
        int n = fArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                float v;
                if (!((v = fArray[n2]) > max)) continue;
                max = v;
            } while (++n2 < n);
        }
        return (float)var1_1;
    }

    @DyvilModifiers(value=327688L)
    @DyvilName(value="max")
    @ReceiverType(value="Ljava/lang/Math;")
    public static float max$_array(float @NonNull [] array) {
        return MathUtils.max(array);
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static double max(double a, double b, double c) {
        return MathUtils.max(a, MathUtils.max(b, c));
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static double max(double ... values) {
        void var1_1;
        double max = Double.NEGATIVE_INFINITY;
        double[] dArray = values;
        int n = dArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                double v;
                if (!((v = dArray[n2]) > max)) continue;
                max = v;
            } while (++n2 < n);
        }
        return (double)var1_1;
    }

    @DyvilModifiers(value=327688L)
    @DyvilName(value="max")
    @ReceiverType(value="Ljava/lang/Math;")
    public static double max$_array(double @NonNull [] array) {
        return MathUtils.max(array);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static int sum(int @NonNull [] values) {
        void var1_1;
        int sum = 0;
        int[] nArray = values;
        int n = nArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                int v = nArray[n2];
                sum += v;
            } while (++n2 < n);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static long sum(long @NonNull [] values) {
        void var1_1;
        long sum = 0L;
        long[] lArray = values;
        int n = lArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                long v = lArray[n2];
                sum += v;
            } while (++n2 < n);
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static float sum(float @NonNull [] values) {
        void var1_1;
        float sum = 0.0f;
        float[] fArray = values;
        int n = fArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                float v = fArray[n2];
                sum += v;
            } while (++n2 < n);
        }
        return (float)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static double sum(double @NonNull [] values) {
        void var1_1;
        double sum = 0.0;
        double[] dArray = values;
        int n = dArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                double v = dArray[n2];
                sum += v;
            } while (++n2 < n);
        }
        return (double)var1_1;
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static <T> T sum(T @NonNull [] values, @DyvilModifiers(value=0x200000L) @NonNull GroupAdd<T> group) {
        return MathUtils.sum(ObjectArray.asIterable(values), group);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static <T> T sum(@NonNull Iterable<T> values, @DyvilModifiers(value=0x200000L) @NonNull GroupAdd<T> group) {
        void var2_2;
        T sum = group.get_0();
        for (T k : values) {
            sum = GroupOperators.$plus(sum, k, group);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static <R, T> T sum(@NonNull Iterable<R> values, @NonNull Function.Of1<R, T> f, @DyvilModifiers(value=0x200000L) @NonNull GroupAdd<T> group) {
        void var3_3;
        T sum = group.get_0();
        for (R k : values) {
            sum = GroupOperators.$plus(sum, f.apply(k), group);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static int product(int @NonNull [] values) {
        void var1_1;
        int product = 1;
        int[] nArray = values;
        int n = nArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                int v = nArray[n2];
                product *= v;
            } while (++n2 < n);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static long product(long @NonNull [] values) {
        void var1_1;
        long product = 1L;
        long[] lArray = values;
        int n = lArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                long v = lArray[n2];
                product *= v;
            } while (++n2 < n);
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static float product(float @NonNull [] values) {
        void var1_1;
        float product = 1.0f;
        float[] fArray = values;
        int n = fArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                float v = fArray[n2];
                product *= v;
            } while (++n2 < n);
        }
        return (float)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static double product(double @NonNull [] values) {
        void var1_1;
        double product = 1.0;
        double[] dArray = values;
        int n = dArray.length;
        if (n > 0) {
            int n2 = 0;
            do {
                double v = dArray[n2];
                product *= v;
            } while (++n2 < n);
        }
        return (double)var1_1;
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static <T> T product(T @NonNull [] values, @DyvilModifiers(value=0x200000L) @NonNull GroupMultiply<T> group) {
        return MathUtils.product(ObjectArray.asIterable(values), group);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static <T> T product(@NonNull Iterable<T> values, @DyvilModifiers(value=0x200000L) @NonNull GroupMultiply<T> group) {
        void var2_2;
        T product = group.get_1();
        for (T k : values) {
            product = GroupOperators.$times(product, k, group);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static <R, T> T product(@NonNull Iterable<R> values, @NonNull Function.Of1<R, T> f, @DyvilModifiers(value=0x200000L) @NonNull GroupMultiply<T> group) {
        void var3_3;
        T product = group.get_1();
        for (R k : values) {
            product = GroupOperators.$times(product, f.apply(k), group);
        }
        return var3_3;
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static double average(int @NonNull [] values) {
        return (double)MathUtils.sum(values) / (double)values.length;
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static double average(long @NonNull [] values) {
        return (double)MathUtils.sum(values) / (double)values.length;
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static double average(float @NonNull [] values) {
        return (double)MathUtils.sum(values) / (double)values.length;
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static double average(double @NonNull [] values) {
        return MathUtils.sum(values) / (double)values.length;
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static int clamp(int value, int min, int max) {
        int n;
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return n;
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static long clamp(long value, long min, long max) {
        long l;
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return l;
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static float clamp(float value, float min, float max) {
        float f;
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return f;
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static double clamp(double value, double min, double max) {
        double d;
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return d;
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static float interpolate(float factor, float min, float max) {
        if (factor <= 0.0f) {
            return min;
        }
        if (factor >= 1.0f) {
            return max;
        }
        return min + factor * (max - min);
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static double interpolate(double factor, double min, double max) {
        if (factor <= 0.0) {
            return min;
        }
        if (factor >= 1.0) {
            return max;
        }
        return min + factor * (max - min);
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static int floor(float f) {
        void var1_1;
        int i = (int)f;
        return f < (float)i ? i - 1 : var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static long floor(double d) {
        void var2_1;
        long l = (long)d;
        return d < (double)l ? l - 1L : var2_1;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static int ceil(float f) {
        void var1_1;
        int i = (int)f;
        return f > (float)i ? i + 1 : var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static long ceil(double d) {
        void var2_1;
        long l = (long)d;
        return d > (double)l ? l + 1L : var2_1;
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static int nextPowerOf2(int v) {
        int j = v - 1;
        j |= j >> 1;
        j |= j >> 2;
        j |= j >> 4;
        j |= j >> 8;
        j |= j >> 16;
        return j + 1;
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static boolean isPowerOf2(int v) {
        return (v & -v) == v;
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/lang/Math;")
    public static int log2(int v) {
        return MathUtils.isPowerOf2(v) ? DeBruijn.subscript(v) : DeBruijn.subscript(MathUtils.nextPowerOf2(v)) - 1;
    }
}

