/*
 * Decompiled with CFR 0.152.
 */
package dyvil.math;

import dyvil.annotation.OverloadPriority;
import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.annotation.internal.Primitive;
import dyvil.lang.LiteralConvertible;
import dyvil.math.group.RingCompatible;
import dyvil.tuple.Tuple;
import java.io.Serializable;

@DyvilModifiers(value=131072L)
@LiteralConvertible.FromDouble
@LiteralConvertible.FromTuple
@ClassParameters(names={"real", "imag"})
public class Complex
implements RingCompatible<Complex>,
Serializable {
    protected final double real;
    protected final double imag;
    public static final @NonNull Complex _i = Complex.apply(0.0, 1.0);
    public static final @NonNull Complex _0 = Complex.apply(0.0);
    public static final @NonNull Complex _1 = Complex.apply(1.0);

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Complex complex = (Complex)object;
        return this.real == complex.real && this.imag == complex.imag;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.real);
        long l2 = Double.doubleToLongBits(this.imag);
        return ((31 + (int)(l | l >>> 32)) * 31 + (int)(l2 | l2 >>> 32)) * 31;
    }

    public String toString() {
        return "Complex(" + this.real + ", " + this.imag + ")";
    }

    @DyvilName(value="real")
    public double getReal() {
        return this.real;
    }

    @DyvilName(value="imag")
    public double getImag() {
        return this.imag;
    }

    @DyvilName(value="_0")
    public static @NonNull Complex get_0() {
        return _0;
    }

    public static /* bridge */ /* synthetic */ RingCompatible get_0() {
        return Complex.get_0();
    }

    @DyvilName(value="_1")
    public static @NonNull Complex get_1() {
        return _1;
    }

    public static /* bridge */ /* synthetic */ RingCompatible get_1() {
        return Complex.get_1();
    }

    public Complex(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    @DyvilModifiers(value=0x210000L)
    public static @NonNull Complex apply(double real) {
        return new Complex(real, 0.0);
    }

    @DyvilModifiers(value=65536L)
    @OverloadPriority
    public static @NonNull Complex apply(double real, double imag) {
        return new Complex(real, imag);
    }

    @DyvilModifiers(value=65536L)
    @DyvilName(value="apply")
    public static @NonNull Complex fromPolar(@DyvilModifiers(value=0x400000L) double length, @DyvilModifiers(value=0x400000L) double argument) {
        return new Complex(length * Math.cos(argument), length * Math.sin(argument));
    }

    public double length() {
        return Math.hypot(this.real, this.imag);
    }

    public double argument() {
        return Math.atan2(this.imag, this.real);
    }

    @DyvilModifiers(value=65536L)
    public static @NonNull Complex $plus(@NonNull Complex rhs) {
        return rhs;
    }

    public static /* bridge */ /* synthetic */ RingCompatible $plus(RingCompatible ringCompatible) {
        return Complex.$plus((Complex)ringCompatible);
    }

    public static @NonNull Complex $minus(@NonNull Complex rhs) {
        return Complex.apply(-rhs.real, -rhs.imag);
    }

    public static /* bridge */ /* synthetic */ RingCompatible $minus(RingCompatible ringCompatible) {
        return Complex.$minus((Complex)ringCompatible);
    }

    public static @NonNull Complex $tilde(@NonNull Complex rhs) {
        return Complex.apply(rhs.real, -rhs.imag);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Complex inverse(@NonNull Complex lhs) {
        return Complex.$div(1.0, lhs);
    }

    public static /* bridge */ /* synthetic */ RingCompatible inverse(RingCompatible ringCompatible) {
        return Complex.inverse((Complex)ringCompatible);
    }

    public static double $bar_$bar(@NonNull Complex c) {
        return c.length();
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Complex $plus(@NonNull Complex lhs, @NonNull Complex rhs) {
        return Complex.apply(lhs.real + rhs.real, lhs.imag + rhs.imag);
    }

    public static /* bridge */ /* synthetic */ RingCompatible $plus(RingCompatible ringCompatible, RingCompatible ringCompatible2) {
        return Complex.$plus((Complex)ringCompatible, (Complex)ringCompatible2);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Complex $minus(@NonNull Complex lhs, @NonNull Complex rhs) {
        return Complex.apply(lhs.real - rhs.real, lhs.imag - rhs.imag);
    }

    public static /* bridge */ /* synthetic */ RingCompatible $minus(RingCompatible ringCompatible, RingCompatible ringCompatible2) {
        return Complex.$minus((Complex)ringCompatible, (Complex)ringCompatible2);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Complex $times(double lhs, @NonNull Complex rhs) {
        return Complex.apply(lhs * rhs.real, lhs * rhs.imag);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Complex $times(@NonNull Complex lhs, double rhs) {
        return Complex.apply(lhs.real * rhs, lhs.imag * rhs);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Complex $times(@NonNull Complex lhs, @NonNull Complex rhs) {
        double lr = lhs.real;
        double li = lhs.imag;
        double rr = rhs.real;
        double ri = rhs.imag;
        double real = lr * rr - ri * li;
        double imag = li * rr + lr * ri;
        return Complex.apply(real, imag);
    }

    public static /* bridge */ /* synthetic */ RingCompatible $times(RingCompatible ringCompatible, RingCompatible ringCompatible2) {
        return Complex.$times((Complex)ringCompatible, (Complex)ringCompatible2);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Complex $div(@NonNull Complex lhs, double rhs) {
        return Complex.apply(lhs.real / rhs, lhs.imag / rhs);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Complex $div(double lhs, @NonNull Complex rhs) {
        double rr = rhs.real;
        double ri = rhs.imag;
        double d = lhs / (rr * rr + ri * ri);
        return Complex.apply(rr * d, -ri * d);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Complex $div(@NonNull Complex lhs, @NonNull Complex rhs) {
        double lr = lhs.real;
        double li = lhs.imag;
        double rr = rhs.real;
        double ri = rhs.imag;
        double d = 1.0 / (rr * rr + ri * ri);
        return Complex.apply((lr * rr + li * ri) * d, (li * rr - lr * ri) * d);
    }

    public static /* bridge */ /* synthetic */ RingCompatible $div(RingCompatible ringCompatible, RingCompatible ringCompatible2) {
        return Complex.$div((Complex)ringCompatible, (Complex)ringCompatible2);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Complex $times$times(@NonNull Complex lhs, int rhs) {
        return Complex.$times$times(lhs, (double)rhs);
    }

    public static /* bridge */ /* synthetic */ RingCompatible $times$times(RingCompatible ringCompatible, int n) {
        return Complex.$times$times((Complex)ringCompatible, n);
    }

    @DyvilModifiers(value=131072L)
    public static @NonNull Complex $times$times(@NonNull Complex lhs, double rhs) {
        return Complex.fromPolar(Math.pow(lhs.length(), rhs), lhs.argument() * rhs);
    }

    public static final @NonNull Tuple.Of2<@Primitive Double, @Primitive Double> unapply(@NonNull Complex value) {
        return new Tuple.Of2<Double, Double>(value.real, value.imag);
    }

    public static final @Nullable Tuple.Of2<@Primitive Double, @Primitive Double> unapply(@Primitive Object value) {
        return value instanceof Complex ? Complex.unapply((Complex)value) : null;
    }
}

