/*
 * Decompiled with CFR 0.152.
 */
package dyvil.lang;

import dyvil.annotation.Immutable;
import dyvil.annotation.Intrinsic;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.annotation.internal.ReceiverType;
import dyvil.array.ObjectArray;
import dyvil.collection.Range;
import dyvil.function.Function;
import dyvil.lang.Objects;
import dyvil.lang.Patterns;
import dyvil.lang.StringChars;
import dyvil.lang.UnsafeString;
import dyvil.runtime.LambdaMetafactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@DyvilModifiers(value=262144L)
@DyvilName(value="extension_Ljava_lang_String__")
public class Strings {
    private static void lambda$0(@NonNull String string, int n, StringBuilder stringBuilder) {
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(string);
        }
    }

    @DyvilModifiers(value=393224L)
    @ReceiverType(value="Ljava/lang/String;")
    public static boolean $tilde$eq(@NonNull String pattern, @NonNull String value) {
        return pattern.equals(value);
    }

    @DyvilModifiers(value=393224L)
    @ReceiverType(value="Ljava/lang/String;")
    public static boolean $tilde$eq(@NonNull Pattern pattern, @NonNull String value) {
        return Patterns.matches(pattern, value);
    }

    @DyvilModifiers(value=1074135048L)
    @Intrinsic(value={}, compilerCode=1)
    @ReceiverType(value="Ljava/lang/String;")
    public static @NonNull String $plus(char lhs, @NonNull String rhs) {
        return new StringBuilder(40).append(lhs).append(rhs).toString();
    }

    @DyvilModifiers(value=1074135048L)
    @Intrinsic(value={}, compilerCode=1)
    @ReceiverType(value="Ljava/lang/String;")
    public static @NonNull String $plus(@NonNull String lhs, char rhs) {
        return new StringBuilder(40).append(lhs).append(rhs).toString();
    }

    @DyvilModifiers(value=1074135048L)
    @Intrinsic(value={}, compilerCode=1)
    @ReceiverType(value="Ljava/lang/String;")
    public static @NonNull String $plus$plus(@NonNull String lhs, @NonNull String rhs) {
        return lhs.concat(rhs);
    }

    @DyvilModifiers(value=458760L)
    @ReceiverType(value="Ljava/lang/String;")
    public static @NonNull String $times(int lhs, @NonNull String rhs) {
        return Strings.repeat(rhs, lhs);
    }

    @DyvilModifiers(value=458760L)
    @ReceiverType(value="Ljava/lang/String;")
    public static @NonNull String $times(@NonNull String lhs, int rhs) {
        return Strings.repeat(lhs, rhs);
    }

    @DyvilModifiers(value=327688L)
    @ReceiverType(value="Ljava/lang/String;")
    public static @NonNull String apply(@Primitive Object value) {
        return new StringBuilder(20).append("").append(value).append("").toString();
    }

    @DyvilModifiers(value=2424840L)
    @ReceiverType(value="Ljava/lang/String;")
    public static @NonNull String apply(@NonNull CharSequence sequence) {
        String string = sequence.toString();
        string.getClass();
        return string;
    }

    @DyvilModifiers(value=327688L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/lang/String;")
    public static @NonNull String build(@DyvilModifiers(value=131072L) @NonNull Function.Of1<@NonNull StringBuilder, @Primitive Void> closure) {
        return Objects.use(new StringBuilder(), closure).toString();
    }

    @DyvilModifiers(value=327688L)
    @DyvilName(value="apply")
    @ReceiverType(value="Ljava/lang/String;")
    public static @NonNull String build(int capacity, @DyvilModifiers(value=131072L) @NonNull Function.Of1<@NonNull StringBuilder, @Primitive Void> closure) {
        return Objects.use(new StringBuilder(capacity), closure).toString();
    }

    @Deprecated
    @DyvilModifiers(value=262152L)
    @dyvil.annotation.Deprecated
    @DyvilName(value="__apply")
    @ReceiverType(value="Ljava/lang/String;")
    public static @NonNull String fromShared(char @Immutable @NonNull [] array) {
        return UnsafeString.fromShared(array);
    }

    @Deprecated
    @DyvilModifiers(value=327680L)
    @dyvil.annotation.Deprecated(description="use String.charCount", since="0.45.0", forRemoval="v0.46.0", replacements={"String.charCount"})
    @ReceiverType(value="Ljava/lang/String;")
    public static final int size(String this_) {
        return this_.length();
    }

    @DyvilModifiers(value=327680L)
    @ReceiverType(value="Ljava/lang/String;")
    public static final char subscript(String this_, int index) {
        return this_.charAt(index);
    }

    @DyvilModifiers(value=327680L)
    @ReceiverType(value="Ljava/lang/String;")
    public static final @NonNull String subscript(String this_, @NonNull Range<@Primitive Integer> range) {
        return this_.substring(range.first(), range.last() + 1);
    }

    @Deprecated
    @DyvilModifiers(value=262144L)
    @dyvil.annotation.Deprecated
    @DyvilName(value="__getCharArray")
    @ReceiverType(value="Ljava/lang/String;")
    public static final char @Immutable @NonNull [] getCharArray(String this_) {
        return UnsafeString.getCharArray(this_);
    }

    @Deprecated
    @DyvilModifiers(value=262144L)
    @dyvil.annotation.Deprecated
    @DyvilName(value="__contains")
    @ReceiverType(value="Ljava/lang/String;")
    public static final boolean contains(String this_, char character) {
        return StringChars.contains(this_, character);
    }

    @Deprecated
    @DyvilModifiers(value=262144L)
    @dyvil.annotation.Deprecated
    @DyvilName(value="__count")
    @ReceiverType(value="Ljava/lang/String;")
    public static final int count(String this_, char character) {
        return StringChars.count(this_, character);
    }

    @Deprecated
    @DyvilModifiers(value=262144L)
    @dyvil.annotation.Deprecated
    @DyvilName(value="__split")
    @ReceiverType(value="Ljava/lang/String;")
    public static final @NonNull String @NonNull [] split(String this_, char delimiter) {
        return StringChars.split(this_, delimiter);
    }

    @DyvilModifiers(value=327680L)
    @ReceiverType(value="Ljava/lang/String;")
    public static final @NonNull String format(String this_, Object ... args) {
        return String.format(this_, args);
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/String;")
    public static final int count(String this_, @NonNull String substring) {
        return Strings.count(this_, substring, 0, this_.length());
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/String;")
    public static final int count(String this_, @NonNull String substring, int from, int to) {
        int subLen = substring.length();
        int count = 0;
        int i = from;
        while (0 <= (i = this_.indexOf(substring, i)) && i + subLen <= to) {
            ++count;
            i += subLen;
        }
        return count;
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/String;")
    public static final @NonNull String @NonNull [] split(String this_, @DyvilModifiers(value=0x400000L) @NonNull String delimiter) {
        int n;
        if (this_.isEmpty()) {
            return new String[]{""};
        }
        if (delimiter.isEmpty()) {
            return StringChars.charGroups(this_, 1);
        }
        int delimiterLength = delimiter.length();
        int upperBound = this_.length() / delimiterLength + 1;
        String[] array = new String[upperBound];
        int start = 0;
        int n2 = upperBound;
        for (int i = 0; i < n2; ++i) {
            int index = this_.indexOf(delimiter, start);
            if (index < 0) {
                array[i] = this_.substring(start);
                break;
            }
            array[i] = this_.substring(start, index);
            start = index + delimiterLength;
        }
        for (n = array.length; n > 0 && (array[n - 1] == null || array[n - 1].isEmpty()); --n) {
        }
        return ObjectArray.trim(array, n);
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/String;")
    public static final int distance(String this_, @NonNull String that) {
        if (this_.equals(that)) {
            return 0;
        }
        int size1 = this_.length();
        int size2 = that.length();
        if (size1 == 0) {
            return size2;
        }
        if (size2 == 0) {
            return size1;
        }
        int arraySize = size2 + 1;
        int[] array1 = new int[arraySize];
        int[] array2 = new int[arraySize];
        int n = arraySize;
        for (int i = 0; i < n; ++i) {
            array1[i] = i;
        }
        int n2 = size1;
        for (int i = 0; i < n2; ++i) {
            array2[0] = i + 1;
            int n3 = size2;
            for (int j = 0; j < n3; ++j) {
                int offset = Strings.subscript(this_, i) != Strings.subscript(that, j) ? 1 : 0;
                array2[j + 1] = Math.min(array2[j] + 1, Math.min(array1[j + 1] + 1, array1[j] + offset));
            }
            System.arraycopy(array2, 0, array1, 0, arraySize);
        }
        return array2[size2];
    }

    @DyvilModifiers(value=327680L)
    @ReceiverType(value="Ljava/lang/String;")
    public static final @NonNull String replaceAll(String this_, @NonNull String regex, @NonNull Function.Of1<@NonNull String, @NonNull String> replacer) {
        return Strings.replaceAll(this_, Patterns.apply(regex), replacer);
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/String;")
    public static final @NonNull String replaceAll(String this_, @NonNull Pattern pattern, @NonNull Function.Of1<@NonNull String, @NonNull String> replacer) {
        Matcher matcher = pattern.matcher(this_);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, replacer.apply(matcher.group()));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    @DyvilModifiers(value=262144L)
    @DyvilName(value="repeated")
    @ReceiverType(value="Ljava/lang/String;")
    public static final @NonNull String repeat(String this_, int times) {
        String string;
        switch (times) {
            case 0: {
                string = "";
                break;
            }
            case 1: {
                string = this_;
                break;
            }
            case 2: {
                string = this_.concat(this_);
                break;
            }
            default: {
                string = Strings.build(this_.length() * times, (Function.Of1<StringBuilder, void>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$0(java.lang.String int java.lang.StringBuilder ), (Ljava/lang/StringBuilder;)V)((String)this_, (int)times));
                break;
            }
        }
        return string;
    }
}

