/*
 * Decompiled with CFR 0.152.
 */
package dyvil.lang;

import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.ReceiverType;
import dyvil.lang.Strings;

@DyvilModifiers(value=262144L)
@DyvilName(value="extension_Ljava_lang_String__")
public class StringChars {
    @DyvilModifiers(value=327680L)
    @ReceiverType(value="Ljava/lang/String;")
    public static final int charCount(String this_) {
        return this_.length();
    }

    @DyvilModifiers(value=327680L)
    @ReceiverType(value="Ljava/lang/String;")
    public static final boolean contains(String this_, char character) {
        return this_.indexOf(character) >= 0;
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/String;")
    public static final int count(String this_, char character) {
        return StringChars.count(this_, character, 0, this_.length());
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/String;")
    public static final int count(String this_, char character, int from, int to) {
        int count = 0;
        int n = to;
        for (int i = from; i < n; ++i) {
            if (this_.charAt(i) != character) continue;
            ++count;
        }
        return count;
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/String;")
    public static final @NonNull String @NonNull [] split(String this_, char delimiter) {
        int end;
        if (this_.isEmpty()) {
            return new String[]{""};
        }
        for (end = this_.length(); end > 0 && this_.charAt(end - 1) == delimiter; --end) {
        }
        if (end == 0) {
            return new String[0];
        }
        int count = StringChars.count(this_, delimiter, 0, end);
        if (count == 0) {
            return new String[]{this_.substring(0, end)};
        }
        String[] array = new String[count + 1];
        int start = 0;
        int arrayIndex = 0;
        int n = end;
        for (int i = 0; i < n; ++i) {
            if (Strings.subscript(this_, i) != delimiter) continue;
            array[arrayIndex] = this_.substring(start, i);
            ++arrayIndex;
            start = i + 1;
        }
        array[arrayIndex] = this_.substring(start, end);
        return array;
    }

    /*
     * WARNING - void declaration
     */
    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/String;")
    public static final @NonNull String @NonNull [] charGroups(String this_, int width) {
        void var3_3;
        if (this_.isEmpty()) {
            return new String[0];
        }
        int count = (this_.length() + width - 1) / width;
        String[] array = new String[count];
        int n = count - 1;
        for (int i = 0; i < n; ++i) {
            this_.substring(i * width, (i + 1) * width).getClass();
        }
        String string = this_.substring((count - 1) * width);
        string.getClass();
        array[count - 1] = string;
        return var3_3;
    }
}

