/*
 * Decompiled with CFR 0.152.
 */
package dyvil.lang;

import dyvil.annotation.Deprecated;
import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.collection.Map;
import dyvil.collection.mutable.HashMap;
import dyvil.lang.LiteralConvertible;
import dyvil.util.Qualifier;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

@LiteralConvertible.FromString
@ClassParameters(names={"unqualified", "qualified"})
public final class Name {
    public final @NonNull String unqualified;
    public final @NonNull String qualified;
    private static final int CACHE_CAPACITY = 1024;
    private static final @NonNull Map<@NonNull String, @NonNull Name> CACHE = new HashMap<String, Name>(CACHE_CAPACITY);

    @DyvilName(value="unqualified")
    public @NonNull String getUnqualified() {
        return this.unqualified;
    }

    @DyvilName(value="qualified")
    public @NonNull String getQualified() {
        return this.qualified;
    }

    private Name(@NonNull String unqualified, @NonNull String qualified) {
        this.unqualified = unqualified;
        this.qualified = qualified;
    }

    public static @NonNull Name apply(@NonNull String value) {
        Name name = CACHE.get(value);
        if (name != null) {
            return name;
        }
        return Name.apply(Qualifier.unqualify(value), Qualifier.qualify(value));
    }

    @Deprecated(replacements={"Name.apply(value: String)"})
    public static @NonNull Name from(@NonNull String value) {
        return Name.apply(value);
    }

    public static @NonNull Name apply(@NonNull String unqualified, @NonNull String qualified) {
        Name name = CACHE.get(qualified);
        if (name != null) {
            return name;
        }
        return Name.create(unqualified, qualified);
    }

    @Deprecated(replacements={"Name.apply(unqualified: String, qualified: String)"})
    public static @NonNull Name from(@NonNull String unqualified, @NonNull String qualified) {
        return Name.apply(unqualified, qualified);
    }

    @DyvilName(value="apply")
    public static @NonNull Name fromRaw(@DyvilModifiers(value=0x400000L) @NonNull String value) {
        Name name = CACHE.get(value);
        if (name != null) {
            return name;
        }
        return Name.create(value);
    }

    @DyvilName(value="apply")
    public static @NonNull Name fromUnqualified(@DyvilModifiers(value=0x400000L) @NonNull String unqualified) {
        Object qualified = CACHE.get(unqualified);
        if (qualified != null) {
            return qualified;
        }
        qualified = Qualifier.qualify(unqualified);
        Name name = CACHE.get(qualified);
        if (name != null) {
            return name;
        }
        return Name.create(unqualified, (String)qualified);
    }

    @DyvilName(value="apply")
    public static @NonNull Name fromQualified(@DyvilModifiers(value=0x400000L) @NonNull String qualified) {
        Object unqualified = CACHE.get(qualified);
        if (unqualified != null) {
            return unqualified;
        }
        unqualified = Qualifier.unqualify(qualified);
        Name name = CACHE.get(unqualified);
        if (name != null) {
            return name;
        }
        return Name.create((String)unqualified, qualified);
    }

    /*
     * WARNING - void declaration
     */
    private static @NonNull Name create(@NonNull String qualified) {
        void var1_1;
        Name name = new Name(qualified, qualified);
        CACHE.put(qualified, name);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static @NonNull Name create(@NonNull String unqualified, @NonNull String qualified) {
        void var2_2;
        Name name = new Name(unqualified, qualified);
        CACHE.put(unqualified, name);
        CACHE.put(qualified, name);
        return var2_2;
    }

    public static Name read(@NonNull DataInput input) throws @NonNull IOException {
        String string = input.readUTF();
        if (string != null && !string.isEmpty()) {
            return Name.fromUnqualified(string);
        }
        return null;
    }

    @DyvilModifiers(value=131072L)
    public static void write(Name name, @NonNull DataOutput output) throws @NonNull IOException {
        Name name2 = name;
        output.writeUTF(name2 != null ? name2.unqualified : "");
    }

    public void write(@NonNull DataOutput output) throws @NonNull IOException {
        output.writeUTF(this.unqualified);
    }

    public boolean equals(@NonNull String qualified) {
        return this.qualified.equals(qualified);
    }

    public boolean startsWith(@NonNull String qualified) {
        return this.qualified.startsWith(qualified);
    }

    public boolean endsWith(@NonNull String qualified) {
        return this.qualified.endsWith(qualified);
    }

    public @NonNull String toString() {
        return this.unqualified;
    }
}

