/*
 * Decompiled with CFR 0.152.
 */
package dyvil.io;

import dyvil.annotation.internal.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class StringPoolWriter
extends FilterOutputStream
implements DataOutput {
    private int constantPoolSize;
    private String[] constantPool;
    private Map<String, Integer> poolIndices;
    private ByteArrayOutputStream dataBytes = new ByteArrayOutputStream();
    private DataOutputStream dataOutputStream = new DataOutputStream(this.dataBytes);

    public StringPoolWriter(@NonNull OutputStream target) {
        this(target, 16);
    }

    public StringPoolWriter(@NonNull OutputStream target, int constantPoolSize) {
        super(target);
        this.constantPool = new String[constantPoolSize];
        this.poolIndices = new HashMap<String, Integer>(constantPoolSize);
    }

    @Override
    public void write(int b) throws IOException {
        this.dataOutputStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.dataOutputStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.dataOutputStream.write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.dataOutputStream.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.dataOutputStream.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.dataOutputStream.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.dataOutputStream.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.dataOutputStream.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.dataOutputStream.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.dataOutputStream.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.dataOutputStream.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.dataOutputStream.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.dataOutputStream.writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        int index = this.poolIndex(s);
        this.dataOutputStream.writeShort(index);
    }

    protected int poolIndex(String constant) {
        int index;
        Integer cachedIndex = this.poolIndices.get(constant);
        if (cachedIndex != null) {
            return cachedIndex;
        }
        if ((index = this.constantPoolSize++) >= this.constantPool.length) {
            String[] temp = new String[index << 1];
            System.arraycopy(this.constantPool, 0, temp, 0, this.constantPool.length);
            this.constantPool = temp;
        }
        this.constantPool[index] = constant;
        this.poolIndices.put(constant, index);
        return index;
    }

    @Override
    public void close() throws IOException {
        ByteArrayOutputStream constantPoolBytes = new ByteArrayOutputStream(this.constantPoolSize << 2);
        DataOutputStream constantPoolOutput = new DataOutputStream(constantPoolBytes);
        constantPoolOutput.writeShort(this.constantPoolSize);
        for (int i = 0; i < this.constantPoolSize; ++i) {
            constantPoolOutput.writeUTF(this.constantPool[i]);
        }
        constantPoolBytes.writeTo(this.out);
        this.dataBytes.writeTo(this.out);
        super.close();
    }
}

