/*
 * Decompiled with CFR 0.152.
 */
package dyvil.io;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.annotation.internal.Primitive;
import dyvil.tuple.Tuple;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;

@DyvilModifiers(value=131072L)
@ClassParameters(names={"builder"})
public class StringBuilderWriter
extends Writer
implements Serializable {
    protected final @NonNull StringBuilder builder;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StringBuilderWriter stringBuilderWriter = (StringBuilderWriter)object;
        return this.builder.equals(stringBuilderWriter.builder);
    }

    public int hashCode() {
        StringBuilder stringBuilder = this.builder;
        return (31 + (stringBuilder != null ? stringBuilder.hashCode() : 0)) * 31;
    }

    public String toString() {
        return "StringBuilderWriter(" + this.builder + ")";
    }

    @DyvilName(value="builder")
    public @NonNull StringBuilder getBuilder() {
        return this.builder;
    }

    public StringBuilderWriter(@NonNull StringBuilder builder) {
        this.builder = builder;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws @NonNull IOException {
        this.builder.append(cbuf, off, len);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public static final @NonNull StringBuilderWriter apply(@NonNull StringBuilder builder) {
        return new StringBuilderWriter(builder);
    }

    public static final @NonNull Tuple.Of1<@NonNull StringBuilder> unapply(@NonNull StringBuilderWriter value) {
        return new Tuple.Of1<StringBuilder>(value.builder);
    }

    public static final @Nullable Tuple.Of1<@NonNull StringBuilder> unapply(@Primitive Object value) {
        return value instanceof StringBuilderWriter ? StringBuilderWriter.unapply((StringBuilderWriter)value) : null;
    }
}

