/*
 * Decompiled with CFR 0.152.
 */
package dyvil.io;

import dyvil.annotation.internal.NonNull;
import dyvil.io.BasicPrintStream;
import dyvil.io.LoggerLevel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggerPrintStream
extends BasicPrintStream {
    private Level level;
    private Logger logger;
    private @NonNull StringBuilder buffer = new StringBuilder();

    public LoggerPrintStream(Logger logger, Level level) {
        super(System.out);
        this.logger = logger;
        this.level = level;
    }

    public LoggerPrintStream(Logger logger) {
        this(logger, Level.INFO);
    }

    public LoggerPrintStream(Logger logger, @NonNull String name) {
        this(logger, new LoggerLevel(name, 1000));
    }

    @Override
    protected void writeln(String s) {
        this.logger.log(this.level, s);
    }

    @Override
    protected void write(String s) {
        this.buffer.append(s);
    }

    @Override
    protected void write(char c) {
        this.buffer.append(c);
        if (c == '\n') {
            this.writeln(this.buffer.toString());
            this.buffer.delete(0, this.buffer.length());
        }
    }
}

