/*
 * Decompiled with CFR 0.152.
 */
package dyvil.io;

import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.annotation.internal.ReceiverType;
import dyvil.io.IOAction;
import dyvil.io.IOSupplier;
import dyvil.lang.Patterns;
import dyvil.runtime.LambdaMetafactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.regex.Pattern;

@DyvilModifiers(value=262144L)
@DyvilName(value="extension_Ljava_io_File__")
public class Files {
    private static void lambda$0(File file) {
        Files.create(file);
    }

    private static void lambda$1(File file) {
        Files.createRecursively(file);
    }

    private static void lambda$2(File file, byte[] byArray) {
        Files.writeData(file, byArray);
    }

    private static void lambda$3(File file, String string) {
        Files.writeText(file, string);
    }

    private static void lambda$4(File file, List list) {
        Files.writeLines(file, list);
    }

    private static byte[] lambda$5(File file) {
        return Files.readData(file);
    }

    private static String lambda$6(File file) {
        return Files.readText(file);
    }

    private static List lambda$7(File file) {
        return Files.readLines(file);
    }

    @DyvilModifiers(value=262152L)
    @ReceiverType(value="Ljava/io/File;")
    public static @NonNull Pattern antPattern(@NonNull String pattern) {
        int length = pattern.length();
        StringBuilder builder = new StringBuilder(length);
        int n = length;
        block14: for (int i = 0; i < n; ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '$': {
                    builder.append("\\$");
                    continue block14;
                }
                case '(': {
                    builder.append("\\(");
                    continue block14;
                }
                case ')': {
                    builder.append("\\)");
                    continue block14;
                }
                case '*': {
                    if (i + 1 < length && pattern.charAt(i + 1) == '*') {
                        builder.append(".*");
                        continue block14;
                    }
                    builder.append("[^/]*");
                    continue block14;
                }
                case '.': {
                    builder.append("\\.");
                    continue block14;
                }
                case '?': {
                    builder.append(".");
                    continue block14;
                }
                case '[': {
                    builder.append("\\[");
                    continue block14;
                }
                case ']': {
                    builder.append("\\]");
                    continue block14;
                }
                case '^': {
                    builder.append("\\^");
                    continue block14;
                }
                case '{': {
                    builder.append("\\{");
                    continue block14;
                }
                case '|': {
                    builder.append("\\|");
                    continue block14;
                }
                case '}': {
                    builder.append("\\}");
                    continue block14;
                }
                default: {
                    char c2 = c;
                    builder.append(c2);
                    continue block14;
                }
            }
        }
        String string = builder.toString();
        string.getClass();
        return Patterns.apply(string);
    }

    @DyvilModifiers(value=327680L)
    @ReceiverType(value="Ljava/io/File;")
    public static final void create(File this_) throws @NonNull IOException {
        this_.createNewFile();
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/io/File;")
    public static final boolean tryCreate(File this_) {
        return IOAction.tryIO((IOAction)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$0(java.io.File ), ()V)((File)this_));
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/io/File;")
    public static final void createRecursively(File this_) throws @NonNull IOException {
        if (this_.exists()) {
            return;
        }
        File file = this_.getParentFile();
        if (file != null && !file.exists() && !file.mkdirs()) {
            throw new IOException(new StringBuilder(54).append("could not create parent directory ").append(file).append("").toString());
        }
        this_.createNewFile();
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/io/File;")
    public static final boolean tryCreateRecursively(File this_) {
        return IOAction.tryIO((IOAction)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$1(java.io.File ), ()V)((File)this_));
    }

    @DyvilModifiers(value=262144L)
    @DyvilName(value="write")
    @ReceiverType(value="Ljava/io/File;")
    public static final void writeData(File this_, byte @NonNull [] data) throws @NonNull IOException {
        Files.createRecursively(this_);
        java.nio.file.Files.write(this_.toPath(), data, new OpenOption[0]);
    }

    @DyvilModifiers(value=262144L)
    @DyvilName(value="tryWrite")
    @ReceiverType(value="Ljava/io/File;")
    public static final boolean tryWriteData(File this_, byte @NonNull [] data) {
        return IOAction.tryIO((IOAction)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$2(java.io.File byte[] ), ()V)((File)this_, (byte[])data));
    }

    @DyvilModifiers(value=262144L)
    @DyvilName(value="write")
    @ReceiverType(value="Ljava/io/File;")
    public static final void writeText(File this_, @NonNull String text) throws @NonNull IOException {
        byte[] byArray = text.getBytes();
        byArray.getClass();
        Files.writeData(this_, byArray);
    }

    @DyvilModifiers(value=262144L)
    @DyvilName(value="tryWrite")
    @ReceiverType(value="Ljava/io/File;")
    public static final boolean tryWriteText(File this_, @NonNull String text) {
        return IOAction.tryIO((IOAction)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$3(java.io.File java.lang.String ), ()V)((File)this_, (String)text));
    }

    @DyvilModifiers(value=262144L)
    @DyvilName(value="write")
    @ReceiverType(value="Ljava/io/File;")
    public static final void writeLines(File this_, @NonNull List<@NonNull String> lines) throws @NonNull IOException {
        Files.createRecursively(this_);
        java.nio.file.Files.write(this_.toPath(), lines, Charset.defaultCharset(), new OpenOption[0]);
    }

    @DyvilModifiers(value=262144L)
    @DyvilName(value="tryWrite")
    @ReceiverType(value="Ljava/io/File;")
    public static final boolean tryWriteLines(File this_, @NonNull List<@NonNull String> lines) {
        return IOAction.tryIO((IOAction)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$4(java.io.File java.util.List ), ()V)((File)this_, lines));
    }

    @DyvilModifiers(value=327680L)
    @ReceiverType(value="Ljava/io/File;")
    public static final byte @NonNull [] readData(File this_) throws @NonNull IOException {
        byte[] byArray = java.nio.file.Files.readAllBytes(this_.toPath());
        byArray.getClass();
        return byArray;
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/io/File;")
    public static final byte @Nullable [] tryReadData(File this_) {
        return IOSupplier.tryIO((IOSupplier<byte[]>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$5(java.io.File ), ()[B)((File)this_));
    }

    @DyvilModifiers(value=327680L)
    @ReceiverType(value="Ljava/io/File;")
    public static final @NonNull String readText(File this_) throws @NonNull IOException {
        return new String(Files.readData(this_));
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/io/File;")
    public static final @Nullable String tryReadText(File this_) {
        return IOSupplier.tryIO((IOSupplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$6(java.io.File ), ()Ljava/lang/String;)((File)this_));
    }

    @DyvilModifiers(value=327680L)
    @ReceiverType(value="Ljava/io/File;")
    public static final @NonNull List<@NonNull String> readLines(File this_) throws @NonNull IOException {
        return java.nio.file.Files.readAllLines(this_.toPath());
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/io/File;")
    public static final @Nullable List<@NonNull String> tryReadLines(File this_) {
        return IOSupplier.tryIO((IOSupplier<List>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$7(java.io.File ), ()Ljava/util/List;)((File)this_));
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/io/File;")
    public static final boolean deleteRecursively(File this_) {
        return Files.deleteRecursively(this_, Integer.MAX_VALUE);
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/io/File;")
    public static final boolean deleteRecursively(File this_, int maxDepth) {
        int n;
        File[] fileArray;
        if (maxDepth > 0 && this_.isDirectory() && (fileArray = this_.listFiles()) != null && (n = fileArray.length) > 0) {
            int n2 = 0;
            do {
                File subFile = fileArray[n2];
                Files.deleteRecursively(subFile, maxDepth - 1);
            } while (++n2 < n);
        }
        return this_.delete();
    }
}

