/*
 * Decompiled with CFR 0.152.
 */
package dyvil.io;

import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.annotation.internal.ReceiverType;
import dyvil.function.Function;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public abstract class Console {
    public static final @NonNull String ANSI_RESET = "\u001b[0m";
    public static final @NonNull String ANSI_BOLD = "\u001b[1m";
    public static final @NonNull String ANSI_DIM = "\u001b[2m";
    public static final @NonNull String ANSI_ITALIC = "\u001b[3m";
    public static final @NonNull String ANSI_UNDERLINE = "\u001b[4m";
    public static final @NonNull String ANSI_BLINK = "\u001b[5m";
    public static final @NonNull String ANSI_FAST_BLINK = "\u001b[6m";
    public static final @NonNull String ANSI_INVERSE = "\u001b[7m";
    public static final @NonNull String ANSI_HIDDEN = "\u001b[8m";
    public static final @NonNull String ANSI_STRIKETHROUGH = "\u001b[9m";
    public static final @NonNull String ANSI_BLACK = "\u001b[30m";
    public static final @NonNull String ANSI_RED = "\u001b[31m";
    public static final @NonNull String ANSI_GREEN = "\u001b[32m";
    public static final @NonNull String ANSI_YELLOW = "\u001b[33m";
    public static final @NonNull String ANSI_BLUE = "\u001b[34m";
    public static final @NonNull String ANSI_PURPLE = "\u001b[35m";
    public static final @NonNull String ANSI_CYAN = "\u001b[36m";
    public static final @NonNull String ANSI_WHITE = "\u001b[37m";
    private static BufferedReader reader;
    private static PrintStream out;

    private Console() {
    }

    public static boolean isTerminalOutput() {
        return System.console() != null;
    }

    public static void setOut(@NonNull PrintStream out) {
        Console.out = out;
    }

    public static void setIn(@NonNull InputStream in) {
        reader = new BufferedReader(new InputStreamReader(in));
    }

    public static void writeLine() {
        out.println();
    }

    public static void writeLine(@Primitive Object value) {
        out.println(value);
    }

    public static void writeLine(@NonNull String value) {
        out.println(value);
    }

    @DyvilModifiers(value=262144L)
    @ReceiverType(value="Ljava/lang/String;")
    public static final @NonNull String styled(String this_, @NonNull String style) {
        return new StringBuilder(60).append(style).append(this_).append(ANSI_RESET).toString();
    }

    @DyvilModifiers(value=262144L)
    @DyvilName(value="append")
    @ReceiverType(value="Ljava/lang/StringBuilder;")
    public static final @NonNull StringBuilder appendStyled(StringBuilder this_, @NonNull String text, @NonNull String style) {
        StringBuilder stringBuilder = this_.append(style).append(text).append(ANSI_RESET);
        stringBuilder.getClass();
        stringBuilder.getClass();
        return stringBuilder;
    }

    @DyvilModifiers(value=262144L)
    @DyvilName(value="append")
    @ReceiverType(value="Ljava/lang/StringBuilder;")
    public static final @NonNull StringBuilder appendStyled(StringBuilder this_, @NonNull String style, @DyvilModifiers(value=131072L) @NonNull Function.Of1<@NonNull StringBuilder, @Primitive Void> body) {
        this_.append(style);
        body.apply(this_);
        StringBuilder stringBuilder = this_.append(ANSI_RESET);
        stringBuilder.getClass();
        stringBuilder.getClass();
        return stringBuilder;
    }

    public static String readLine() {
        try {
            return reader.readLine();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static @NonNull String readString() {
        String string = Console.readLine();
        string.getClass();
        return string;
    }

    public static String readString(int charCount) {
        char[] chars = new char[charCount];
        try {
            reader.read(chars);
            return new String(chars);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static byte readByte() {
        return (byte)Integer.parseInt(Console.readLine());
    }

    public static short readShort() {
        return (short)Integer.parseInt(Console.readLine());
    }

    public static char readChar() {
        return (char)Console.readCodePoint();
    }

    public static int readCodePoint() {
        try {
            return reader.read();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public static int readInt() {
        return Integer.parseInt(Console.readLine());
    }

    public static long readLong() {
        return Long.parseLong(Console.readLine());
    }

    public static float readFloat() {
        return Float.parseFloat(Console.readLine());
    }

    public static double readDouble() {
        return Double.parseDouble(Console.readLine());
    }

    static {
        PrintStream printStream = System.out;
        printStream.getClass();
        Console.setOut(printStream);
        InputStream inputStream = System.in;
        inputStream.getClass();
        Console.setIn(inputStream);
    }
}

