/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.view;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.NonNull;
import dyvil.collection.Collection;
import dyvil.collection.ImmutableSet;
import dyvil.collection.MutableSet;
import dyvil.collection.Set;
import dyvil.collection.iterator.ImmutableIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

@Immutable
public class SetView<E>
implements ImmutableSet<E> {
    private static final long serialVersionUID = 816522991709785465L;
    protected final Set<E> set;

    public SetView(Set<E> collection) {
        this.set = collection;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public @NonNull Iterator<E> iterator() {
        return this.set.isImmutable() ? this.set.iterator() : new ImmutableIterator<E>(this.set.iterator());
    }

    @Override
    public void forEach(@NonNull Consumer<? super E> action) {
        this.set.forEach(action);
    }

    @Override
    public @NonNull ImmutableSet<E> added(E element) {
        return new SetView<E>(this.set.added((Object)element));
    }

    @Override
    public @NonNull ImmutableSet<E> removed(Object element) {
        return new SetView<E>(this.set.removed(element));
    }

    @Override
    public @NonNull ImmutableSet<E> union(@NonNull Collection<? extends E> collection) {
        return new SetView<E>(this.set.union((Collection)collection));
    }

    @Override
    public @NonNull ImmutableSet<E> difference(@NonNull Collection<?> collection) {
        return new SetView<E>(this.set.difference(collection));
    }

    @Override
    public @NonNull ImmutableSet<E> intersection(@NonNull Collection<? extends E> collection) {
        return new SetView<E>(this.set.intersection((Collection)collection));
    }

    @Override
    public @NonNull ImmutableSet<E> symmetricDifference(@NonNull Collection<? extends E> collection) {
        return new SetView<E>(this.set.symmetricDifference(collection));
    }

    @Override
    public <R> @NonNull ImmutableSet<R> mapped(@NonNull Function<? super E, ? extends R> mapper) {
        return new SetView<E>(this.set.mapped(mapper));
    }

    @Override
    public <R> @NonNull ImmutableSet<R> flatMapped(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends R>> mapper) {
        return new SetView<E>(this.set.flatMapped(mapper));
    }

    @Override
    public @NonNull ImmutableSet<E> filtered(@NonNull Predicate<? super E> predicate) {
        return new SetView<E>(this.set.filtered(predicate));
    }

    @Override
    public @NonNull ImmutableSet<E> copy() {
        return new SetView<E>(this.set.copy());
    }

    @Override
    public <RE> MutableSet<RE> emptyCopy() {
        return this.set.emptyCopy();
    }

    @Override
    public <RE> @NonNull MutableSet<RE> emptyCopy(int capacity) {
        return this.set.emptyCopy(capacity);
    }

    @Override
    public @NonNull MutableSet<E> mutable() {
        return this.set.mutable();
    }

    @Override
    public <RE> ImmutableSet.Builder<RE> immutableBuilder() {
        return this.set.immutableBuilder();
    }

    @Override
    public <RE> ImmutableSet.Builder<RE> immutableBuilder(int capacity) {
        return this.set.immutableBuilder(capacity);
    }

    @Override
    public @NonNull java.util.Set<E> toJava() {
        return this.set.isImmutable() ? this.set.toJava() : Collections.unmodifiableSet(this.set.toJava());
    }

    @Override
    public @NonNull String toString() {
        return "view " + this.set.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return this.set.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.set.hashCode();
    }
}

