/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.view;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Collection;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableMap;
import dyvil.collection.Map;
import dyvil.collection.MutableMap;
import dyvil.collection.iterator.ImmutableIterator;
import dyvil.util.Option;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;

@Immutable
public class MapView<K, V>
implements ImmutableMap<K, V> {
    private static final long serialVersionUID = 1586369703282366862L;
    protected final Map<K, V> map;

    public MapView(Map<K, V> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public @NonNull Iterator<Entry<K, V>> iterator() {
        return this.map.isImmutable() ? this.map.iterator() : new ImmutableIterator<Entry<K, V>>(this.map.iterator());
    }

    @Override
    public @NonNull Iterator<K> keyIterator() {
        return this.map.isImmutable() ? this.map.keyIterator() : new ImmutableIterator<K>(this.map.keyIterator());
    }

    @Override
    public @NonNull Iterator<V> valueIterator() {
        return this.map.isImmutable() ? this.map.valueIterator() : new ImmutableIterator<V>(this.map.valueIterator());
    }

    @Override
    public void forEach(@NonNull BiConsumer<? super K, ? super V> action) {
        this.map.forEach(action);
    }

    @Override
    public void forEach(@NonNull Consumer<? super Entry<K, V>> action) {
        this.map.forEach((Consumer<Entry<K, V>>)action);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public boolean contains(Object key, Object value) {
        return this.map.contains(key, value);
    }

    @Override
    public @Nullable V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Entry<K, V> getEntry(Object key) {
        return this.map.getEntry(key);
    }

    @Override
    public @NonNull Option<V> getOption(Object key) {
        return this.map.getOption(key);
    }

    @Override
    public @NonNull ImmutableMap<K, V> withEntry(K key, V value) {
        return new MapView<K, V>(this.map.withEntry(key, value));
    }

    @Override
    public @NonNull ImmutableMap<K, V> union(@NonNull Map<? extends K, ? extends V> map) {
        return new MapView<K, V>(this.map.union(map));
    }

    @Override
    public @NonNull ImmutableMap<K, V> keyRemoved(Object key) {
        return new MapView<K, V>(this.map.keyRemoved(key));
    }

    @Override
    public @NonNull ImmutableMap<K, V> removed(Object key, Object value) {
        return new MapView<K, V>(this.map.removed(key, value));
    }

    @Override
    public @NonNull ImmutableMap<K, V> valueRemoved(Object value) {
        return new MapView<K, V>(this.map.valueRemoved(value));
    }

    @Override
    public @NonNull ImmutableMap<K, V> difference(@NonNull Map<?, ?> map) {
        return new MapView<K, V>(this.map.difference(map));
    }

    @Override
    public @NonNull ImmutableMap<K, V> keyDifference(@NonNull Collection<?> keys) {
        return new MapView<K, V>(this.map.keyDifference(keys));
    }

    @Override
    public <NK> @NonNull ImmutableMap<NK, V> keyMapped(@NonNull BiFunction<? super K, ? super V, ? extends NK> mapper) {
        return new MapView<NK, V>(this.map.keyMapped(mapper));
    }

    @Override
    public <NV> @NonNull ImmutableMap<K, NV> valueMapped(@NonNull BiFunction<? super K, ? super V, ? extends NV> mapper) {
        return new MapView<K, NV>(this.map.valueMapped(mapper));
    }

    @Override
    public <NK, NV> @NonNull ImmutableMap<NK, NV> entryMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Entry<? extends NK, ? extends NV>> mapper) {
        return new MapView(this.map.entryMapped(mapper));
    }

    @Override
    public <NK, NV> @NonNull ImmutableMap<NK, NV> flatMapped(@NonNull BiFunction<? super K, ? super V, ? extends @NonNull Iterable<? extends @NonNull Entry<? extends NK, ? extends NV>>> mapper) {
        return new MapView(this.map.flatMapped(mapper));
    }

    @Override
    public @NonNull ImmutableMap<K, V> filtered(@NonNull BiPredicate<? super K, ? super V> predicate) {
        return new MapView<K, V>(this.map.filtered(predicate));
    }

    @Override
    public @NonNull ImmutableMap<V, K> inverted() {
        return new MapView<V, K>(this.map.inverted());
    }

    @Override
    public @NonNull ImmutableMap<K, V> copy() {
        return new MapView<K, V>(this.map.copy());
    }

    @Override
    public <RK, RV> MutableMap<RK, RV> emptyCopy() {
        return this.map.emptyCopy();
    }

    @Override
    public <RK, RV> MutableMap<RK, RV> emptyCopy(int capacity) {
        return this.map.emptyCopy(capacity);
    }

    @Override
    public @NonNull MutableMap<K, V> mutable() {
        return this.map.mutable();
    }

    @Override
    public <RK, RV> ImmutableMap.Builder<RK, RV> immutableBuilder() {
        return this.map.immutableBuilder();
    }

    @Override
    public <RK, RV> ImmutableMap.Builder<RK, RV> immutableBuilder(int capacity) {
        return this.map.immutableBuilder(capacity);
    }

    @Override
    public @NonNull java.util.Map<K, V> toJava() {
        return this.map.isImmutable() ? this.map.toJava() : Collections.unmodifiableMap(this.map.toJava());
    }

    @Override
    public @NonNull String toString() {
        return "view " + this.map.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }
}

