/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.view;

import dyvil.annotation.internal.NonNull;
import dyvil.collection.Collection;
import dyvil.collection.Map;
import dyvil.collection.Queryable;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;

public class MapValues<V>
implements Queryable<V> {
    private final Map<?, V> entries;

    public MapValues(Map<?, V> entries) {
        this.entries = entries;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public @NonNull Iterator<V> iterator() {
        return this.entries.valueIterator();
    }

    @Override
    public void map(@NonNull Function<? super V, ? extends V> mapper) {
        this.entries.mapValues(mapper);
    }

    @Override
    public void flatMap(@NonNull Function<? super V, ? extends @NonNull Iterable<? extends V>> mapper) {
        throw new UnsupportedOperationException("flatMap() on Map Values");
    }

    @Override
    public void filter(@NonNull Predicate<? super V> predicate) {
        this.entries.filterByValue(predicate);
    }

    @Override
    public <R> @NonNull Queryable<R> mapped(@NonNull Function<? super V, ? extends R> mapper) {
        Map<?, R> entries = this.entries.valueMapped(mapper);
        return entries.values();
    }

    @Override
    public <R> @NonNull Queryable<R> flatMapped(@NonNull Function<? super V, ? extends @NonNull Iterable<? extends R>> mapper) {
        throw new UnsupportedOperationException("flatMapped() on Map Values");
    }

    @Override
    public @NonNull Queryable<V> filtered(@NonNull Predicate<? super V> predicate) {
        return this.entries.filteredByValue(predicate).values();
    }

    public @NonNull String toString() {
        return this.toString("[", ", ", "]");
    }

    public boolean equals(Object obj) {
        return obj instanceof MapValues && Collection.unorderedEquals(this, (MapValues)obj);
    }

    public int hashCode() {
        return Collection.unorderedHashCode(this);
    }
}

