/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.view;

import dyvil.annotation.internal.NonNull;
import dyvil.collection.Collection;
import dyvil.collection.Map;
import dyvil.collection.Queryable;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;

public class MapKeys<K>
implements Queryable<K> {
    private final Map<K, ?> entries;

    public MapKeys(Map<K, ?> entries) {
        this.entries = entries;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public @NonNull Iterator<K> iterator() {
        return this.entries.keyIterator();
    }

    @Override
    public void map(@NonNull Function<? super K, ? extends K> mapper) {
        this.entries.mapKeys(mapper);
    }

    @Override
    public void flatMap(@NonNull Function<? super K, ? extends @NonNull Iterable<? extends K>> mapper) {
        throw new UnsupportedOperationException("flatMap() on Map Keys");
    }

    @Override
    public void filter(@NonNull Predicate<? super K> predicate) {
        this.entries.filterByKey(predicate);
    }

    @Override
    public <R> @NonNull Queryable<R> mapped(@NonNull Function<? super K, ? extends R> mapper) {
        Map<R, ?> entries = this.entries.keyMapped(mapper);
        return entries.keys();
    }

    @Override
    public <R> @NonNull Queryable<R> flatMapped(@NonNull Function<? super K, ? extends @NonNull Iterable<? extends R>> mapper) {
        throw new UnsupportedOperationException("flatMapped() on Map Keys");
    }

    @Override
    public @NonNull Queryable<K> filtered(@NonNull Predicate<? super K> predicate) {
        return this.entries.filteredByKey(predicate).keys();
    }

    public @NonNull String toString() {
        return this.toString("[", ", ", "]");
    }

    public boolean equals(Object obj) {
        return obj instanceof MapKeys && Collection.unorderedEquals(this, (MapKeys)obj);
    }

    public int hashCode() {
        return Collection.unorderedHashCode(this);
    }
}

