/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.view;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.NonNull;
import dyvil.collection.Collection;
import dyvil.collection.ImmutableList;
import dyvil.collection.List;
import dyvil.collection.MutableList;
import dyvil.collection.iterator.ImmutableIterator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

@Immutable
public class ListView<E>
implements ImmutableList<E> {
    private static final long serialVersionUID = -4432411036304678600L;
    protected final List<E> list;

    public ListView(List<E> list) {
        this.list = list;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public @NonNull Iterator<E> iterator() {
        return this.list.isImmutable() ? this.list.iterator() : new ImmutableIterator<E>(this.list.iterator());
    }

    @Override
    public @NonNull Iterator<E> reverseIterator() {
        return this.list.isImmutable() ? this.list.reverseIterator() : new ImmutableIterator<E>(this.list.reverseIterator());
    }

    @Override
    public void forEach(@NonNull Consumer<? super E> action) {
        this.list.forEach(action);
    }

    @Override
    public <R> R foldLeft(R initialValue, @NonNull BiFunction<? super R, ? super E, ? extends R> reducer) {
        return this.list.foldLeft(initialValue, reducer);
    }

    @Override
    public <R> R foldRight(R initialValue, @NonNull BiFunction<? super E, ? super R, ? extends R> reducer) {
        return this.list.foldRight(initialValue, reducer);
    }

    @Override
    public E reduceLeft(@NonNull BiFunction<? super E, ? super E, ? extends E> reducer) {
        return this.list.reduceLeft(reducer);
    }

    @Override
    public E reduceRight(@NonNull BiFunction<? super E, ? super E, ? extends E> reducer) {
        return this.list.reduceRight(reducer);
    }

    @Override
    public E subscript(int index) {
        return this.list.subscript(index);
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public @NonNull ImmutableList<E> subList(int startIndex, int length) {
        return new ListView<E>(this.list.subList(startIndex, length));
    }

    @Override
    public @NonNull ImmutableList<E> added(E element) {
        return new ListView<E>(this.list.added((Object)element));
    }

    @Override
    public @NonNull ImmutableList<E> union(@NonNull Collection<? extends E> collection) {
        return new ListView<E>(this.list.union((Collection)collection));
    }

    @Override
    public @NonNull ImmutableList<E> removed(Object element) {
        return new ListView<E>(this.list.removed(element));
    }

    @Override
    public @NonNull ImmutableList<E> difference(@NonNull Collection<?> collection) {
        return new ListView<E>(this.list.difference((Collection)collection));
    }

    @Override
    public @NonNull ImmutableList<E> intersection(@NonNull Collection<? extends E> collection) {
        return new ListView<E>(this.list.intersection((Collection)collection));
    }

    @Override
    public <R> @NonNull ImmutableList<R> mapped(@NonNull Function<? super E, ? extends R> mapper) {
        return new ListView<E>(this.list.mapped(mapper));
    }

    @Override
    public <R> @NonNull ImmutableList<R> flatMapped(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends R>> mapper) {
        return new ListView<E>(this.list.flatMapped(mapper));
    }

    @Override
    public @NonNull ImmutableList<E> filtered(@NonNull Predicate<? super E> predicate) {
        return new ListView<E>(this.list.filtered(predicate));
    }

    @Override
    public @NonNull ImmutableList<E> reversed() {
        return new ListView<E>(this.list.reversed());
    }

    @Override
    public @NonNull ImmutableList<E> sorted() {
        return new ListView<E>(this.list.sorted());
    }

    @Override
    public @NonNull ImmutableList<E> sorted(@NonNull Comparator<? super E> comparator) {
        return new ListView<E>(this.list.sorted(comparator));
    }

    @Override
    public @NonNull ImmutableList<E> distinct() {
        return new ListView<E>(this.list.distinct());
    }

    @Override
    public @NonNull ImmutableList<E> distinct(@NonNull Comparator<? super E> comparator) {
        return new ListView<E>(this.list.distinct());
    }

    @Override
    public int indexOf(Object element) {
        return this.list.indexOf(element);
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.list.lastIndexOf(element);
    }

    @Override
    public @NonNull ImmutableList<E> copy() {
        return new ListView<E>(this.list.copy());
    }

    @Override
    public <RE> @NonNull MutableList<RE> emptyCopy() {
        return this.list.emptyCopy();
    }

    @Override
    public <RE> @NonNull MutableList<RE> emptyCopy(int capacity) {
        return this.list.emptyCopy(capacity);
    }

    @Override
    public @NonNull MutableList<E> mutable() {
        return this.list.mutable();
    }

    @Override
    public <RE> ImmutableList.Builder<RE> immutableBuilder() {
        return this.list.immutableBuilder();
    }

    @Override
    public <RE> ImmutableList.Builder<RE> immutableBuilder(int capacity) {
        return this.list.immutableBuilder(capacity);
    }

    @Override
    public @NonNull java.util.List<E> toJava() {
        return this.list.isImmutable() ? this.list.toJava() : Collections.unmodifiableList(this.list.toJava());
    }

    @Override
    public @NonNull String toString() {
        return "view " + this.list.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return this.list.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }
}

