/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.range.halfopen;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.collection.Range;
import dyvil.collection.range.halfopen.LongRange;
import dyvil.function.Function;
import java.util.Iterator;

@ClassParameters(names={"start", "end"})
public class LongRange
implements dyvil.collection.range.specialized.LongRange {
    @DyvilModifiers(value=0x8000000L)
    final long start;
    @DyvilModifiers(value=0x8000000L)
    final long end;

    public LongRange(long start, long end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public boolean isHalfOpen() {
        return true;
    }

    @Override
    public @NonNull dyvil.collection.range.specialized.LongRange asHalfOpen() {
        return this;
    }

    @Override
    public @NonNull dyvil.collection.range.specialized.LongRange asClosed() {
        return new dyvil.collection.range.closed.LongRange(this.start, this.end);
    }

    @Override
    public long first() {
        return this.start;
    }

    @Override
    public long last() {
        return this.end - 1L;
    }

    @Override
    public int size() {
        return (int)(this.end - this.start + 1L);
    }

    @Override
    public @NonNull Iterator<@Primitive Long> iterator() {
        return new 1(this);
    }

    @Override
    public void forEach(@NonNull Function.Of1<@Primitive Long, @Primitive Void> action) {
        long l = this.end;
        for (long i = this.start; i < l; ++i) {
            action.apply(i);
        }
    }

    @Override
    public boolean contains(long value) {
        return value >= this.start && value < this.end;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long @NonNull [] toLongArray() {
        void var1_1;
        long[] result = new long[this.size()];
        int index = 0;
        long i = this.start;
        long l = this.end;
        while (i < l) {
            result[index] = i++;
            ++index;
        }
        return var1_1;
    }

    @Override
    public @NonNull LongRange copy() {
        return new LongRange(this.start, this.end);
    }

    @Override
    public void copy(Object @NonNull [] to, int index) {
        long l = this.end;
        for (long i = this.start; i < l; ++i) {
            to[index] = i;
            ++index;
        }
    }

    public @NonNull String toString() {
        return new StringBuilder(45).append("").append(this.start).append(" ..< ").append(this.end).append("").toString();
    }

    public boolean equals(Object obj) {
        return Range.rangeEquals((Range<? extends Object>)this, obj);
    }

    public int hashCode() {
        return Range.rangeHashCode(this);
    }
}

