/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.range.halfopen;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.collection.Range;
import dyvil.collection.range.halfopen.FloatRange;
import dyvil.function.Function;
import java.util.Iterator;

@ClassParameters(names={"start", "end"})
public class FloatRange
implements dyvil.collection.range.specialized.FloatRange {
    @DyvilModifiers(value=0x8000000L)
    final float start;
    @DyvilModifiers(value=0x8000000L)
    final float end;

    public FloatRange(float start, float end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public boolean isHalfOpen() {
        return true;
    }

    @Override
    public @NonNull dyvil.collection.range.specialized.FloatRange asHalfOpen() {
        return this;
    }

    @Override
    public @NonNull dyvil.collection.range.specialized.FloatRange asClosed() {
        return new dyvil.collection.range.closed.FloatRange(this.start, this.end);
    }

    @Override
    public float first() {
        return this.start;
    }

    @Override
    public float last() {
        return this.end - 1.0f;
    }

    @Override
    public int size() {
        return (int)(this.end - this.start + 1.0f);
    }

    @Override
    public @NonNull Iterator<@Primitive Float> iterator() {
        return new 1(this);
    }

    @Override
    public void forEach(@NonNull Function.Of1<@Primitive Float, @Primitive Void> action) {
        float f = this.end;
        for (float i = this.start; i < f; i += 1.0f) {
            action.apply(Float.valueOf(i));
        }
    }

    @Override
    public boolean contains(float value) {
        return value >= this.start && value < this.end;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float @NonNull [] toFloatArray() {
        void var1_1;
        float[] result = new float[this.size()];
        int index = 0;
        float f = this.end;
        for (float i = this.start; i < f; i += 1.0f) {
            result[index] = i;
            ++index;
        }
        return var1_1;
    }

    @Override
    public @NonNull FloatRange copy() {
        return new FloatRange(this.start, this.end);
    }

    @Override
    public void copy(Object @NonNull [] to, int index) {
        float f = this.end;
        for (float i = this.start; i < f; i += 1.0f) {
            to[index] = Float.valueOf(i);
            ++index;
        }
    }

    public @NonNull String toString() {
        return new StringBuilder(45).append("").append(this.start).append(" ..< ").append(this.end).append("").toString();
    }

    public boolean equals(Object obj) {
        return Range.rangeEquals((Range<? extends Object>)this, obj);
    }

    public int hashCode() {
        return Range.rangeHashCode(this);
    }
}

