/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.range.halfopen;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.collection.Range;
import dyvil.collection.range.halfopen.DoubleRange;
import dyvil.function.Function;
import java.util.Iterator;

@ClassParameters(names={"start", "end"})
public class DoubleRange
implements dyvil.collection.range.specialized.DoubleRange {
    @DyvilModifiers(value=0x8000000L)
    final double start;
    @DyvilModifiers(value=0x8000000L)
    final double end;

    public DoubleRange(double start, double end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public boolean isHalfOpen() {
        return true;
    }

    @Override
    public @NonNull dyvil.collection.range.specialized.DoubleRange asHalfOpen() {
        return this;
    }

    @Override
    public @NonNull dyvil.collection.range.specialized.DoubleRange asClosed() {
        return new dyvil.collection.range.closed.DoubleRange(this.start, this.end);
    }

    @Override
    public double first() {
        return this.start;
    }

    @Override
    public double last() {
        return this.end - 1.0;
    }

    @Override
    public int size() {
        return (int)(this.end - this.start + 1.0);
    }

    @Override
    public @NonNull Iterator<@Primitive Double> iterator() {
        return new 1(this);
    }

    @Override
    public void forEach(@NonNull Function.Of1<@Primitive Double, @Primitive Void> action) {
        double d = this.end;
        for (double i = this.start; i < d; i += 1.0) {
            action.apply(i);
        }
    }

    @Override
    public boolean contains(double value) {
        return value >= this.start && value < this.end;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double @NonNull [] toDoubleArray() {
        void var1_1;
        double[] result = new double[this.size()];
        int index = 0;
        double d = this.end;
        for (double i = this.start; i < d; i += 1.0) {
            result[index] = i;
            ++index;
        }
        return var1_1;
    }

    @Override
    public @NonNull DoubleRange copy() {
        return new DoubleRange(this.start, this.end);
    }

    @Override
    public void copy(Object @NonNull [] to, int index) {
        double d = this.end;
        for (double i = this.start; i < d; i += 1.0) {
            to[index] = i;
            ++index;
        }
    }

    public @NonNull String toString() {
        return new StringBuilder(45).append("").append(this.start).append(" ..< ").append(this.end).append("").toString();
    }

    public boolean equals(Object obj) {
        return Range.rangeEquals((Range<? extends Object>)this, obj);
    }

    public int hashCode() {
        return Range.rangeHashCode(this);
    }
}

