/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.range.closed;

import dyvil.annotation.Immutable;
import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.Covariant;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.DyvilName;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.annotation.internal.Primitive;
import dyvil.collection.Range;
import dyvil.collection.range.Rangeable;
import dyvil.collection.range.closed.ObjectRange;
import dyvil.function.Function;
import dyvil.lang.LiteralConvertible;
import dyvil.lang.Objects;
import dyvil.tuple.Tuple;
import java.util.Iterator;

@DyvilModifiers(value=131072L)
@Immutable
@LiteralConvertible.FromTuple
@ClassParameters(names={"start", "end"})
public class ObjectRange<@Covariant T extends @NonNull Rangeable<T>>
implements Range<T> {
    protected final transient T start;
    protected final transient T end;

    @DyvilName(value="start")
    public T getStart() {
        return this.start;
    }

    @DyvilName(value="end")
    public T getEnd() {
        return this.end;
    }

    public ObjectRange(T start, T end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public boolean isHalfOpen() {
        return false;
    }

    @Override
    public @NonNull Range<T> asHalfOpen() {
        return new dyvil.collection.range.halfopen.ObjectRange<T>(this.start, this.end);
    }

    @Override
    public @NonNull Range<T> asClosed() {
        return this;
    }

    @Override
    public T first() {
        return this.start;
    }

    @Override
    public T last() {
        return this.end;
    }

    @Override
    public int size() {
        return this.start.distanceTo(this.end) + 1;
    }

    @Override
    public @NonNull Iterator<T> iterator() {
        return new 1(this);
    }

    @Override
    public void forEach(@NonNull Function.Of1<T, @Primitive Void> action) {
        Object current = this.start;
        while (Objects.$lt$eq(current, this.end)) {
            action.apply(current);
            current = current.next();
        }
    }

    @Override
    public boolean contains(@Primitive Object element) {
        Object value = this.start;
        while (Objects.$lt$eq(value, this.end)) {
            if (Objects.equals(element, value)) {
                return true;
            }
            value = value.next();
        }
        return false;
    }

    @Override
    public @NonNull ObjectRange<T> copy() {
        return new ObjectRange<T>(this.start, this.end);
    }

    @Override
    public void copy(Object @NonNull [] to, int index) {
        Object value = this.start;
        while (Objects.$lt$eq(value, this.end)) {
            to[index] = value;
            ++index;
            value = value.next();
        }
    }

    public @NonNull String toString() {
        return new StringBuilder(44).append("").append(this.start).append(" .. ").append(this.end).append("").toString();
    }

    public boolean equals(@Primitive Object obj) {
        return Range.rangeEquals((Range<? extends Object>)this, obj);
    }

    public int hashCode() {
        return Range.rangeHashCode(this);
    }

    public static final <T extends Rangeable<T>> @NonNull ObjectRange<T> apply(T start, T end) {
        return new ObjectRange<T>(start, end);
    }

    public static final <T extends Rangeable<T>> @NonNull Tuple.Of2<T, T> unapply(@NonNull ObjectRange<T> value) {
        return new Tuple.Of2<T, T>(value.start, value.end);
    }

    public static final <T extends Rangeable<T>> @Nullable Tuple.Of2<T, T> unapply(@Primitive Object value) {
        return value instanceof ObjectRange ? ObjectRange.unapply((ObjectRange)value) : null;
    }
}

