/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.range.closed;

import dyvil.annotation.internal.ClassParameters;
import dyvil.annotation.internal.DyvilModifiers;
import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Primitive;
import dyvil.collection.Range;
import dyvil.collection.range.closed.IntRange;
import dyvil.function.Function;
import java.util.Iterator;

@ClassParameters(names={"start", "end"})
public class IntRange
implements dyvil.collection.range.specialized.IntRange {
    @DyvilModifiers(value=0x8000000L)
    final int start;
    @DyvilModifiers(value=0x8000000L)
    final int end;

    public IntRange(int start, int end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public boolean isHalfOpen() {
        return false;
    }

    @Override
    public @NonNull dyvil.collection.range.specialized.IntRange asHalfOpen() {
        return new dyvil.collection.range.halfopen.IntRange(this.start, this.end);
    }

    @Override
    public @NonNull dyvil.collection.range.specialized.IntRange asClosed() {
        return this;
    }

    @Override
    public int first() {
        return this.start;
    }

    @Override
    public int last() {
        return this.end;
    }

    @Override
    public int size() {
        return this.end - this.start;
    }

    @Override
    public @NonNull Iterator<@Primitive Integer> iterator() {
        return new 1(this);
    }

    @Override
    public void forEach(@NonNull Function.Of1<@Primitive Integer, @Primitive Void> action) {
        int n = this.end;
        for (int i = this.start; i <= n; ++i) {
            action.apply(i);
        }
    }

    @Override
    public boolean contains(int value) {
        return value >= this.start && value <= this.end;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int @NonNull [] toIntArray() {
        void var1_1;
        int[] result = new int[this.size()];
        int index = 0;
        int i = this.start;
        int n = this.end;
        while (i <= n) {
            result[index] = i++;
            ++index;
        }
        return var1_1;
    }

    @Override
    public @NonNull IntRange copy() {
        return new IntRange(this.start, this.end);
    }

    @Override
    public void copy(Object @NonNull [] to, int index) {
        int n = this.end;
        for (int i = this.start; i <= n; ++i) {
            to[index] = i;
            ++index;
        }
    }

    public @NonNull String toString() {
        return new StringBuilder(44).append("").append(this.start).append(" .. ").append(this.end).append("").toString();
    }

    public boolean equals(Object obj) {
        return Range.rangeEquals((Range<? extends Object>)this, obj);
    }

    public int hashCode() {
        return Range.rangeHashCode(this);
    }
}

