/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.mutable;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableMap;
import dyvil.collection.Map;
import dyvil.collection.MutableMap;
import dyvil.collection.Set;
import dyvil.collection.SizedIterable;
import dyvil.collection.impl.AbstractTupleMap;
import dyvil.lang.LiteralConvertible;
import dyvil.tuple.Tuple;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

@LiteralConvertible.FromArray
public class TupleMap<K, V>
extends AbstractTupleMap<K, V>
implements MutableMap<K, V> {
    private static final long serialVersionUID = 5771226814337471265L;

    public static <K, V> @NonNull TupleMap<K, V> singleton(K key, V value) {
        TupleMap<K, V> result = new TupleMap<K, V>();
        result.putInternal(new Tuple.Of2<K, V>(key, value));
        return result;
    }

    public static <K, V> @NonNull TupleMap<K, V> apply() {
        return new TupleMap<K, V>();
    }

    @SafeVarargs
    public static <K, V> @NonNull TupleMap<K, V> apply(Entry<? extends K, ? extends V> ... entries) {
        return new TupleMap<K, V>(entries);
    }

    @SafeVarargs
    public static <K, V> @NonNull TupleMap<K, V> apply(Tuple.Of2<? extends K, ? extends V> ... entries) {
        return new TupleMap<K, V>(entries, true);
    }

    public static <K, V> @NonNull TupleMap<K, V> from(@NonNull Entry<? extends K, ? extends V> @NonNull [] array) {
        return new TupleMap<K, V>(array);
    }

    public static <K, V> @NonNull TupleMap<K, V> from(@NonNull Tuple.Of2<? extends K, ? extends V> @NonNull [] array) {
        return new TupleMap<K, V>(array);
    }

    public static <K, V> @NonNull TupleMap<K, V> from(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        return new TupleMap<K, V>(iterable);
    }

    public static <K, V> @NonNull TupleMap<K, V> from(@NonNull SizedIterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        return new TupleMap<K, V>(iterable);
    }

    public static <K, V> @NonNull TupleMap<K, V> from(@NonNull Set<? extends @NonNull Entry<? extends K, ? extends V>> set) {
        return new TupleMap<K, V>(set);
    }

    public static <K, V> @NonNull TupleMap<K, V> from(@NonNull Map<? extends K, ? extends V> map) {
        return new TupleMap<K, V>(map);
    }

    public static <K, V> @NonNull TupleMap<K, V> from(@NonNull AbstractTupleMap<? extends K, ? extends V> tupleMap) {
        return new TupleMap<K, V>(tupleMap);
    }

    public TupleMap() {
    }

    public TupleMap(int capacity) {
        super(capacity);
    }

    public TupleMap(Entry<? extends K, ? extends V> @NonNull [] entries) {
        super(entries);
    }

    public TupleMap(Tuple.Of2<? extends K, ? extends V> @NonNull [] entries) {
        super(entries);
    }

    public TupleMap(Tuple.Of2<? extends K, ? extends V> @NonNull [] entries, int size) {
        super(entries, size);
    }

    public TupleMap(Tuple.Of2<? extends K, ? extends V> @NonNull [] entries, boolean trusted) {
        super(entries, trusted);
    }

    public TupleMap(Tuple.Of2<? extends K, ? extends V>[] entries, int size, boolean trusted) {
        super(entries, size, trusted);
    }

    public TupleMap(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        super(iterable);
    }

    public TupleMap(@NonNull SizedIterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        super(iterable);
    }

    public TupleMap(@NonNull Set<? extends @NonNull Entry<? extends K, ? extends V>> set) {
        super(set);
    }

    public TupleMap(@NonNull Map<? extends K, ? extends V> map) {
        super(map);
    }

    public TupleMap(@NonNull AbstractTupleMap<? extends K, ? extends V> map) {
        super(map);
    }

    @Override
    public @Nullable Entry<K, V> getEntry(final Object key) {
        if (!this.containsKey(key)) {
            return null;
        }
        return new Entry<K, V>(){

            @Override
            public @NonNull K getKey() {
                return key;
            }

            @Override
            public @NonNull V getValue() {
                int index = TupleMap.this.getIndex(key);
                return ((TupleMap)TupleMap.this).entries[index]._2;
            }
        };
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.entries[i] = null;
        }
        this.size = 0;
    }

    @Override
    public @Nullable V put(K key, V value) {
        return this.put(new Tuple.Of2<K, V>(key, value));
    }

    @Override
    public @Nullable V put(@NonNull Entry<? extends K, ? extends V> entry) {
        return this.putInternal(entry.toTuple());
    }

    @Override
    public @NonNull V putIfAbsent(K key, V value) {
        return this.putIfAbsent(new Tuple.Of2<K, V>(key, value));
    }

    @Override
    public @NonNull V putIfAbsent(@NonNull Entry<? extends K, ? extends V> entry) {
        return this.putIfAbsent(entry.toTuple());
    }

    @Override
    private @NonNull V putIfAbsent(@NonNull Tuple.Of2<K, V> tuple) {
        Object key = tuple._1;
        for (int i = 0; i < this.size; ++i) {
            Tuple.Of2 entry = this.entries[i];
            if (!Objects.equals(key, entry._1)) continue;
            return (V)entry._2;
        }
        this.putNew(tuple);
        return (V)tuple._2;
    }

    @Override
    public @Nullable V replace(K key, V newValue) {
        return this.replace(new Tuple.Of2<K, V>(key, newValue));
    }

    @Override
    public @Nullable V replace(@NonNull Entry<? extends K, ? extends V> entry) {
        return this.replace(entry.toTuple());
    }

    @Override
    private V replace(@NonNull Tuple.Of2<K, V> tuple) {
        Object key = tuple._1;
        for (int i = 0; i < this.size; ++i) {
            Tuple.Of2 entry = this.entries[i];
            if (!Objects.equals(key, entry._1)) continue;
            Object oldValue = entry._2;
            this.entries[i] = tuple;
            return (V)oldValue;
        }
        return null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        for (int i = 0; i < this.size; ++i) {
            Tuple.Of2 entry = this.entries[i];
            if (!Objects.equals(key, entry._1)) continue;
            if (!Objects.equals(oldValue, entry._2)) {
                return false;
            }
            this.entries[i] = new Tuple.Of2<K, V>(key, newValue);
            return true;
        }
        return false;
    }

    @Override
    protected void removeAt(int index) {
        int numMoved;
        if ((numMoved = --this.size - index) > 0) {
            System.arraycopy(this.entries, index + 1, this.entries, index, numMoved);
        }
        this.entries[this.size] = null;
    }

    @Override
    public @Nullable V removeKey(Object key) {
        for (int i = 0; i < this.size; ++i) {
            Tuple.Of2 entry = this.entries[i];
            if (!Objects.equals(key, entry._1)) continue;
            Object oldValue = entry._2;
            this.removeAt(i);
            return (V)oldValue;
        }
        return null;
    }

    @Override
    public boolean removeValue(Object value) {
        for (int i = 0; i < this.size; ++i) {
            if (!Objects.equals(value, this.entries[i]._2)) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object key, Object value) {
        for (int i = 0; i < this.size; ++i) {
            Tuple.Of2 entry = this.entries[i];
            if (!Objects.equals(key, entry._1)) continue;
            if (Objects.equals(value, entry._2)) {
                this.removeAt(i);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void mapValues(@NonNull BiFunction<? super K, ? super V, ? extends V> mapper) {
        for (int i = 0; i < this.size; ++i) {
            Tuple.Of2 entry = this.entries[i];
            Object key = entry._1;
            this.entries[i] = new Tuple.Of2(key, mapper.apply(key, entry._2));
        }
    }

    @Override
    public void filter(@NonNull BiPredicate<? super K, ? super V> condition) {
        for (int i = 0; i < this.size; ++i) {
            Tuple.Of2 entry = this.entries[i];
            if (condition.test(entry._1, entry._2)) continue;
            this.removeAt(i--);
        }
    }

    @Override
    public @NonNull MutableMap<K, V> copy() {
        return this.mutableCopy();
    }

    @Override
    public @NonNull ImmutableMap<K, V> immutable() {
        return this.immutableCopy();
    }
}

