/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.mutable;

import dyvil.annotation.internal.NonNull;
import dyvil.collection.mutable.MapBasedSet;
import dyvil.collection.mutable.TreeMap;
import dyvil.lang.LiteralConvertible;
import java.util.Comparator;

@LiteralConvertible.FromArray
public class TreeSet<E>
extends MapBasedSet<E> {
    private static final long serialVersionUID = 3616255313908232391L;

    public static <E> @NonNull TreeSet<E> apply() {
        return new TreeSet<E>();
    }

    @SafeVarargs
    public static <E> @NonNull TreeSet<E> apply(E ... elements) {
        return new TreeSet<E>(elements);
    }

    public static <E> @NonNull TreeSet<E> from(E @NonNull [] array) {
        return new TreeSet<E>(array);
    }

    public static <E> @NonNull TreeSet<E> from(@NonNull Iterable<? extends E> iterable) {
        return new TreeSet<E>(iterable);
    }

    public TreeSet() {
        super(new TreeMap());
    }

    public TreeSet(Comparator<? super E> comparator) {
        super(new TreeMap(comparator));
    }

    public TreeSet(E @NonNull [] elements) {
        this();
        for (E element : elements) {
            this.map.put(element, true);
        }
    }

    public TreeSet(@NonNull Iterable<? extends E> iterable) {
        this();
        for (E element : iterable) {
            this.map.put(element, true);
        }
    }
}

