/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.mutable;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableMap;
import dyvil.collection.MutableMap;
import dyvil.collection.impl.AbstractTreeMap;
import dyvil.lang.LiteralConvertible;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

@LiteralConvertible.FromArray
public class TreeMap<K, V>
extends AbstractTreeMap<K, V>
implements MutableMap<K, V> {
    private static final long serialVersionUID = -7707452456610472904L;

    public static <K, V> @NonNull TreeMap<K, V> singleton(K key, V value) {
        TreeMap<K, V> result = new TreeMap<K, V>();
        result.putInternal(key, value);
        return result;
    }

    public static <K, V> @NonNull TreeMap<K, V> apply() {
        return new TreeMap<K, V>();
    }

    @SafeVarargs
    public static <K extends Comparable<K>, V> @NonNull TreeMap<K, V> apply(Entry<? extends K, ? extends V> ... entries) {
        return new TreeMap<K, V>(entries);
    }

    public static <K extends Comparable<K>, V> @NonNull TreeMap<K, V> from(@NonNull Entry<? extends K, ? extends V> @NonNull [] array) {
        return new TreeMap<K, V>(array);
    }

    public static <K extends Comparable<K>, V> @NonNull TreeMap<K, V> from(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        return new TreeMap<K, V>(iterable);
    }

    public static <K extends Comparable<K>, V> @NonNull TreeMap<K, V> from(@NonNull AbstractTreeMap<? extends K, ? extends V> treeMap) {
        return new TreeMap<K, V>(treeMap);
    }

    public TreeMap() {
    }

    public TreeMap(Comparator<? super K> comparator) {
        super(comparator);
    }

    public TreeMap(@NonNull Entry<? extends K, ? extends V> @NonNull [] entries) {
        super(entries);
    }

    public TreeMap(@NonNull Entry<? extends K, ? extends V> @NonNull [] entries, Comparator<? super K> comparator) {
        super(entries, comparator);
    }

    public TreeMap(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> map) {
        super(map);
    }

    public TreeMap(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> map, Comparator<? super K> comparator) {
        super(map, comparator);
    }

    public TreeMap(@NonNull AbstractTreeMap<? extends K, ? extends V> treeMap) {
        super(treeMap);
    }

    public TreeMap(@NonNull AbstractTreeMap<? extends K, ? extends V> treeMap, Comparator<? super K> comparator) {
        super(treeMap, comparator);
    }

    @Override
    public void clear() {
        this.size = 0;
        this.root = null;
    }

    @Override
    public @Nullable V put(K key, V value) {
        return this.putInternal(key, value);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        AbstractTreeMap.TreeEntry entry = this.getEntryInternal(key);
        if (entry != null) {
            return entry.value;
        }
        this.putInternal(key, value);
        return value;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        AbstractTreeMap.TreeEntry p = this.getEntryInternal(key);
        if (p != null && Objects.equals(oldValue, p.value)) {
            p.value = newValue;
            return true;
        }
        return false;
    }

    @Override
    public @Nullable V replace(K key, V value) {
        AbstractTreeMap.TreeEntry p = this.getEntryInternal(key);
        if (p != null) {
            Object oldValue = p.value;
            p.value = value;
            return oldValue;
        }
        return null;
    }

    @Override
    public @Nullable V removeKey(Object key) {
        AbstractTreeMap.TreeEntry entry = this.getEntryInternal(key);
        if (entry == null) {
            return null;
        }
        Object value = entry.value;
        this.deleteEntry(entry);
        return value;
    }

    @Override
    public boolean removeValue(Object value) {
        AbstractTreeMap.TreeEntry e = this.getFirstEntry();
        while (e != null) {
            if (Objects.equals(value, e.value)) {
                this.deleteEntry(e);
                return true;
            }
            e = TreeMap.successor(e);
        }
        return false;
    }

    @Override
    public boolean remove(Object key, Object value) {
        AbstractTreeMap.TreeEntry entry = this.getEntryInternal(key);
        if (entry == null || !Objects.equals(value, entry.value)) {
            return false;
        }
        this.deleteEntry(entry);
        return true;
    }

    @Override
    public void mapValues(@NonNull BiFunction<? super K, ? super V, ? extends V> function) {
        AbstractTreeMap.TreeEntry e = this.getFirstEntry();
        while (e != null) {
            e.value = function.apply(e.key, e.value);
            e = TreeMap.successor(e);
        }
    }

    @Override
    public void filter(@NonNull BiPredicate<? super K, ? super V> condition) {
        AbstractTreeMap.TreeEntry e = this.getFirstEntry();
        while (e != null) {
            AbstractTreeMap.TreeEntry next = TreeMap.successor(e);
            if (!condition.test(e.key, e.value)) {
                this.deleteEntry(e);
            }
            e = next;
        }
    }

    @Override
    public @NonNull MutableMap<K, V> copy() {
        return this.mutableCopy();
    }

    @Override
    public @NonNull ImmutableMap<K, V> immutable() {
        return this.immutableCopy();
    }
}

