/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.mutable;

import dyvil.annotation.internal.NonNull;
import dyvil.collection.Collection;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableSet;
import dyvil.collection.Map;
import dyvil.collection.MutableMap;
import dyvil.collection.MutableSet;
import dyvil.collection.impl.AbstractMapBasedSet;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;

public class MapBasedSet<E>
extends AbstractMapBasedSet<E>
implements MutableSet<E> {
    private static final long serialVersionUID = 3329100687699880194L;
    protected MutableMap<E, Boolean> map;

    public MapBasedSet(MutableMap<E, Boolean> map) {
        this.map = map;
    }

    @Override
    protected Map<E, Boolean> map() {
        return this.map;
    }

    @Override
    public @NonNull MutableSet<E> added(E element) {
        return new MapBasedSet<E>(this.map.withEntry(element, (Object)true));
    }

    @Override
    public @NonNull MutableSet<E> removed(Object element) {
        return new MapBasedSet<E>(this.map.keyRemoved(element));
    }

    @Override
    public @NonNull MutableSet<E> difference(@NonNull Collection<?> collection) {
        return new MapBasedSet<E>(this.map.keyDifference((Collection)collection));
    }

    @Override
    public @NonNull MutableSet<E> intersection(@NonNull Collection<? extends E> collection) {
        MutableMap map = this.map.emptyCopy();
        for (Entry<E, Boolean> entry : this.map) {
            E element = entry.getKey();
            if (!collection.contains(element)) continue;
            map.subscript_$eq(element, true);
        }
        return new MapBasedSet(map);
    }

    @Override
    public @NonNull MutableSet<E> union(@NonNull Collection<? extends E> collection) {
        Map map = this.map.copy();
        for (E element : collection) {
            map.subscript_$eq(element, true);
        }
        return new MapBasedSet<E>(map);
    }

    @Override
    public @NonNull MutableSet<E> symmetricDifference(@NonNull Collection<? extends E> collection) {
        MutableMap map = this.map.emptyCopy();
        for (Entry<E, Boolean> entry : this.map) {
            E element = entry.getKey();
            if (collection.contains(element)) continue;
            map.subscript_$eq(element, true);
        }
        for (Entry<Object, Boolean> entry : collection) {
            if (this.contains(entry)) continue;
            map.subscript_$eq(entry, true);
        }
        return new MapBasedSet(map);
    }

    @Override
    public <R> @NonNull MutableSet<R> mapped(@NonNull Function<? super E, ? extends R> mapper) {
        MutableMap map = this.map.emptyCopy();
        for (Entry<E, Boolean> entry : this.map) {
            map.subscript_$eq(mapper.apply(entry.getKey()), true);
        }
        return new MapBasedSet(map);
    }

    @Override
    public <R> @NonNull MutableSet<R> flatMapped(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends R>> mapper) {
        MutableMap map = this.map.emptyCopy();
        for (Entry<E, Boolean> entry : this.map) {
            for (R element : mapper.apply(entry.getKey())) {
                map.subscript_$eq(element, true);
            }
        }
        return new MapBasedSet(map);
    }

    @Override
    public @NonNull MutableSet<E> filtered(@NonNull Predicate<? super E> predicate) {
        MutableMap map = this.map.emptyCopy();
        for (Entry<E, Boolean> entry : this.map) {
            E element = entry.getKey();
            if (!predicate.test(element)) continue;
            map.subscript_$eq(element, true);
        }
        return new MapBasedSet(map);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean add(E element) {
        return this.map.put(element, true) == null;
    }

    @Override
    public boolean remove(Object element) {
        return this.map.removeKey(element);
    }

    @Override
    public boolean addAll(@NonNull Collection<? extends E> collection) {
        boolean added = false;
        for (E element : collection) {
            if (this.map.put(element, true) != Boolean.TRUE) continue;
            added = true;
        }
        return added;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public boolean retainAll(@NonNull Collection<? extends E> collection) {
        boolean removed = false;
        Iterator<@NonNull Entry<E, Boolean>> iterator = this.map.iterator();
        while (iterator.hasNext()) {
            E element = iterator.next().getKey();
            if (collection.contains(element)) continue;
            iterator.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    public boolean symmetricDifferenceInplace(@NonNull Collection<? extends E> collection) {
        boolean changed = false;
        MutableMap newMap = this.map.emptyCopy();
        for (Entry<E, Boolean> entry : this.map) {
            E element = entry.getKey();
            if (collection.contains(element)) continue;
            newMap.subscript_$eq(element, true);
            changed = true;
        }
        for (Entry<Object, Boolean> entry : collection) {
            if (this.contains(entry)) continue;
            newMap.subscript_$eq(entry, true);
            changed = true;
        }
        this.map = newMap;
        return changed;
    }

    @Override
    public void map(@NonNull Function<? super E, ? extends E> mapper) {
        MutableMap newMap = this.map.emptyCopy();
        for (Entry<E, Boolean> entry : this.map) {
            newMap.subscript_$eq(mapper.apply(entry.getKey()), true);
        }
        this.map = newMap;
    }

    @Override
    public void flatMap(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends E>> mapper) {
        MutableMap newMap = this.map.emptyCopy();
        for (Entry<E, Boolean> entry : this.map) {
            for (E element : mapper.apply(entry.getKey())) {
                newMap.subscript_$eq(element, true);
            }
        }
        this.map = newMap;
    }

    @Override
    public @NonNull MutableSet<E> copy() {
        return this.mutableCopy();
    }

    @Override
    public @NonNull ImmutableSet<E> immutable() {
        return this.immutableCopy();
    }
}

