/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.mutable;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Collection;
import dyvil.collection.Deque;
import dyvil.collection.ImmutableList;
import dyvil.collection.List;
import dyvil.collection.MutableList;
import dyvil.collection.Set;
import dyvil.collection.immutable.AppendList;
import dyvil.lang.LiteralConvertible;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

@LiteralConvertible.FromArray
public class LinkedList<E>
implements MutableList<E>,
Deque<E> {
    private static final long serialVersionUID = 7185956993705123890L;
    protected transient int size;
    protected transient @Nullable Node<E> first;
    protected transient @Nullable Node<E> last;

    public static <E> @NonNull LinkedList<E> apply() {
        return new LinkedList<E>();
    }

    @SafeVarargs
    public static <E> @NonNull LinkedList<E> apply(E ... elements) {
        LinkedList<E> list = new LinkedList<E>();
        for (E element : elements) {
            list.addLast(element);
        }
        return list;
    }

    public LinkedList() {
    }

    LinkedList(@Nullable Node<E> first, @Nullable Node<E> last, int size) {
        this.first = first;
        this.last = last;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public @NonNull Iterator<E> iterator() {
        return new Iterator<E>(){
            @Nullable Node<E> lastReturned;
            @Nullable Node<E> next;
            {
                this.next = LinkedList.this.first;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public @Nullable E next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.next;
                this.next = this.next.next;
                return this.lastReturned.item;
            }

            @Override
            public void remove() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                Node lastNext = this.lastReturned.next;
                LinkedList.this.unlink(this.lastReturned);
                if (this.next == this.lastReturned) {
                    this.next = lastNext;
                }
                this.lastReturned = null;
            }

            public @NonNull String toString() {
                return "LinkedListIterator(" + LinkedList.this + ")";
            }
        };
    }

    @Override
    public @NonNull Iterator<E> reverseIterator() {
        return new Iterator<E>(){
            @Nullable Node<E> lastReturned;
            @Nullable Node<E> prev;
            {
                this.prev = LinkedList.this.last;
            }

            @Override
            public boolean hasNext() {
                return this.prev != null;
            }

            @Override
            public E next() {
                this.lastReturned = this.prev;
                this.prev = this.prev.prev;
                return this.lastReturned.item;
            }

            @Override
            public void remove() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                Node lastPrev = this.lastReturned.prev;
                LinkedList.this.unlink(this.lastReturned);
                if (this.prev == this.lastReturned) {
                    this.prev = lastPrev;
                }
                this.lastReturned = null;
            }

            public @NonNull String toString() {
                return "LinkedListDescendingIterator(" + LinkedList.this + ")";
            }
        };
    }

    @Override
    public <R> R foldLeft(R initialValue, @NonNull BiFunction<? super R, ? super E, ? extends R> reducer) {
        Node<E> node = this.first;
        while (node != null) {
            initialValue = reducer.apply(initialValue, node.item);
            node = node.next;
        }
        return initialValue;
    }

    @Override
    public <R> R foldRight(R initialValue, @NonNull BiFunction<? super E, ? super R, ? extends R> reducer) {
        Node<E> node = this.last;
        while (node != null) {
            initialValue = reducer.apply(node.item, initialValue);
            node = node.prev;
        }
        return initialValue;
    }

    @Override
    public @Nullable E reduceLeft(@NonNull BiFunction<? super E, ? super E, ? extends E> reducer) {
        if (this.size == 0) {
            return null;
        }
        Node<E> node = this.first;
        Object initialValue = node.item;
        while ((node = node.next) != null) {
            initialValue = reducer.apply(initialValue, node.item);
        }
        return initialValue;
    }

    @Override
    public @Nullable E reduceRight(@NonNull BiFunction<? super E, ? super E, ? extends E> reducer) {
        if (this.size == 0) {
            return null;
        }
        Node<E> node = this.last;
        Object initialValue = node.item;
        while ((node = node.prev) != null) {
            initialValue = reducer.apply(node.item, initialValue);
        }
        return initialValue;
    }

    @Override
    public boolean contains(Object element) {
        Node<E> node = this.first;
        while (node != null) {
            if (Objects.equals(element, node.item)) {
                return true;
            }
            node = node.next;
        }
        return false;
    }

    protected @NonNull Node<E> nodeAt(int index) {
        List.rangeCheck(index, this.size);
        Node<E> node = this.first;
        while (index > 0) {
            assert (node != null);
            node = node.next;
            --index;
        }
        return node;
    }

    @Override
    public E get(int index) {
        List.rangeCheck(index, this.size);
        return this.nodeAt((int)index).item;
    }

    @Override
    public @Nullable E getFirst() {
        return this.first == null ? null : (E)this.first.item;
    }

    @Override
    public @Nullable E getLast() {
        return this.last == null ? null : (E)this.last.item;
    }

    @Override
    public @NonNull MutableList<E> subList(int startIndex, int length) {
        List.rangeCheck(startIndex, this.size);
        List.rangeCheck(startIndex + length - 1, this.size);
        LinkedList copy = new LinkedList();
        Node<E> node = this.nodeAt(startIndex);
        while (length > 0) {
            assert (node != null);
            copy.addLast(node.item);
            node = node.next;
            --length;
        }
        return copy;
    }

    @Override
    public @NonNull List<E> reversed() {
        LinkedList ll = new LinkedList();
        Node<E> node = this.first;
        while (node != null) {
            ll.addFirst(node.item);
            node = node.next;
        }
        return ll;
    }

    @Override
    public @NonNull MutableList<E> sorted() {
        LinkedList<E> copy = new LinkedList<E>();
        Object[] array = this.toArray();
        Arrays.sort(array);
        copy.size = this.size;
        copy.fromArray(array, this.size);
        return copy;
    }

    @Override
    public @NonNull MutableList<E> sorted(@NonNull Comparator<? super E> comparator) {
        LinkedList<E> copy = new LinkedList<E>();
        Object[] array = this.toArray();
        Arrays.sort(array, comparator);
        copy.fromArray(array, this.size);
        return copy;
    }

    @Override
    public @NonNull MutableList<E> distinct() {
        LinkedList<E> copy = new LinkedList<E>();
        Object[] array = this.toArray();
        copy.fromArray(array, Set.distinct(array, this.size));
        return copy;
    }

    @Override
    public @NonNull MutableList<E> distinct(@NonNull Comparator<? super E> comparator) {
        LinkedList<E> copy = new LinkedList<E>();
        Object[] array = this.toArray();
        copy.fromArray(array, Set.sortDistinct(array, this.size, comparator));
        return copy;
    }

    @Override
    public void addElement(E element) {
        this.addLast(element);
    }

    @Override
    public @Nullable E set(int index, E element) {
        List.rangeCheck(index, this.size);
        Node<E> node = this.nodeAt(index);
        Object oldElement = node.item;
        node.item = element;
        return oldElement;
    }

    @Override
    public void addFirst(E element) {
        ++this.size;
        Node<E> node = new Node<E>(null, element, this.first);
        if (this.first != null) {
            this.first.prev = node;
        } else {
            this.last = node;
        }
        this.first = node;
    }

    @Override
    public void addLast(E element) {
        ++this.size;
        Node<E> node = new Node<E>(this.last, element, null);
        if (this.last != null) {
            this.last.next = node;
        } else {
            this.first = node;
        }
        this.last = node;
    }

    @Override
    public @Nullable E setResizing(int index, E element) {
        while (index >= this.size) {
            this.addLast(null);
        }
        List.rangeCheck(index, this.size);
        Node<E> node = this.nodeAt(index);
        Object e = node.item;
        node.item = element;
        return e;
    }

    @Override
    public void insert(int index, E element) {
        if (index == 0) {
            this.addFirst(element);
            return;
        }
        if (index == this.size) {
            this.addLast(element);
            return;
        }
        List.rangeCheck(index, this.size);
        Node<E> nodeAt = this.nodeAt(index);
        assert (nodeAt.prev != null);
        Node newNode = new Node(nodeAt.prev, element, nodeAt);
        nodeAt.prev.next = newNode;
        nodeAt.prev = newNode;
    }

    @Override
    public void removeAt(int index) {
        List.rangeCheck(index, this.size);
        this.unlink(this.nodeAt(index));
    }

    protected void unlink(@NonNull Node<E> node) {
        Node next = node.next;
        Node prev = node.prev;
        if (prev == null) {
            this.first = next;
        } else {
            prev.next = next;
            node.prev = null;
        }
        if (next == null) {
            this.last = prev;
        } else {
            next.prev = prev;
            node.next = null;
        }
        node.item = null;
        --this.size;
    }

    @Override
    public @Nullable E removeFirst() {
        if (this.first == null) {
            return null;
        }
        Object e = this.first.item;
        this.unlink(this.first);
        return e;
    }

    @Override
    public @Nullable E removeLast() {
        if (this.last == null) {
            return null;
        }
        Object e = this.last.item;
        this.unlink(this.last);
        return e;
    }

    @Override
    public boolean remove(Object element) {
        boolean removed = false;
        Node<E> node = this.first;
        while (node != null) {
            if (Objects.equals(node.item, element)) {
                Node next = node.next;
                this.unlink(node);
                removed = true;
                node = next;
                continue;
            }
            node = node.next;
        }
        return removed;
    }

    @Override
    public boolean removeFirst(Object element) {
        Node<E> node = this.first;
        while (node != null) {
            if (Objects.equals(node.item, element)) {
                this.unlink(node);
                return true;
            }
            node = node.next;
        }
        return false;
    }

    @Override
    public boolean removeLast(Object element) {
        Node<E> node = this.last;
        while (node != null) {
            if (Objects.equals(node.item, element)) {
                this.unlink(node);
                return true;
            }
            node = node.prev;
        }
        return false;
    }

    @Override
    public @Nullable E peek(int index) {
        if (index >= this.size) {
            return null;
        }
        return this.get(index);
    }

    @Override
    public void clear() {
        Node<E> node = this.first;
        while (node != null) {
            Node next = node.next;
            node.next = null;
            node.prev = null;
            node.item = null;
            node = next;
        }
        this.last = null;
        this.first = null;
        this.size = 0;
    }

    @Override
    public void map(@NonNull Function<? super E, ? extends E> mapper) {
        Node<E> node = this.first;
        while (node != null) {
            node.item = mapper.apply(node.item);
            node = node.next;
        }
    }

    @Override
    public void flatMap(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends E>> mapper) {
        int size = 0;
        Node<E> first = null;
        Node<E> last = null;
        Node<E> node = this.first;
        while (node != null) {
            for (E e : mapper.apply(node.item)) {
                ++size;
                Node<E> current = new Node<E>(first, e, null);
                if (last != null) {
                    last.next = current;
                } else {
                    first = current;
                }
                last = current;
            }
            node = node.next;
        }
        this.size = size;
        this.first = first;
        this.last = last;
    }

    @Override
    public void filter(@NonNull Predicate<? super E> predicate) {
        Node<E> node = this.first;
        while (node != null) {
            Node next = node.next;
            if (!predicate.test(node.item)) {
                this.unlink(node);
            }
            node = next;
        }
    }

    @Override
    public void reverse() {
        Node<E> temp = this.first;
        this.first = this.last;
        this.last = temp;
        Node<E> p = this.last;
        while (p != null) {
            temp = p.next;
            p.next = p.prev;
            p.prev = temp;
            p = p.prev;
        }
    }

    @Override
    public void sort() {
        Object[] array = this.toArray();
        Arrays.sort(array);
        this.fromArray(array, this.size);
    }

    @Override
    public void sort(@NonNull Comparator<? super E> comparator) {
        Object[] array = this.toArray();
        Arrays.sort(array, comparator);
        this.fromArray(array, this.size);
    }

    @Override
    public void distinguish() {
        Object[] array = this.toArray();
        this.fromArray(array, Set.distinct(array, this.size));
    }

    @Override
    public void distinguish(@NonNull Comparator<? super E> comparator) {
        Object[] array = this.toArray();
        this.fromArray(array, Set.distinct(array, this.size));
    }

    protected void fromArray(Object[] array, int size) {
        this.clear();
        for (int i = 0; i < size; ++i) {
            this.addLast(array[i]);
        }
        this.size = size;
    }

    @Override
    public int indexOf(Object element) {
        Node<E> node = this.first;
        int index = 0;
        while (node != null) {
            if (Objects.equals(node.item, element)) {
                return index;
            }
            ++index;
            node = node.next;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object element) {
        Node<E> node = this.last;
        int index = 0;
        while (node != null) {
            if (Objects.equals(node.item, element)) {
                return index;
            }
            ++index;
            node = node.prev;
        }
        return -1;
    }

    @Override
    public void toArray(int index, Object @NonNull [] store) {
        Node<E> node = this.first;
        while (node != null) {
            store[index++] = node.item;
            node = node.next;
        }
    }

    @Override
    public <R> @NonNull MutableList<R> emptyCopy() {
        return new LinkedList<E>();
    }

    @Override
    public <R> @NonNull MutableList<R> emptyCopy(int newCapacity) {
        return this.emptyCopy();
    }

    @Override
    public @NonNull ImmutableList<E> immutable() {
        return AppendList.from(this);
    }

    @Override
    public <RE> ImmutableList.Builder<RE> immutableBuilder() {
        return AppendList.builder();
    }

    @Override
    public <RE> ImmutableList.Builder<RE> immutableBuilder(int capacity) {
        return AppendList.builder();
    }

    @Override
    public @NonNull LinkedList<E> copy() {
        LinkedList copy = new LinkedList();
        Node<E> node = this.first;
        while (node != null) {
            copy.addLast(node.item);
            node = node.next;
        }
        return copy;
    }

    @Override
    public @NonNull java.util.List<E> toJava() {
        java.util.LinkedList list = new java.util.LinkedList();
        Node<E> node = this.first;
        while (node != null) {
            list.addLast(node.item);
            node = node.next;
        }
        return list;
    }

    @Override
    public @NonNull String toString() {
        return Collection.collectionToString(this);
    }

    @Override
    public boolean equals(Object obj) {
        return List.listEquals(this, obj);
    }

    @Override
    public int hashCode() {
        return List.listHashCode(this);
    }

    private void writeObject(@NonNull ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.size);
        Node<E> node = this.first;
        while (node != null) {
            out.writeObject(node.item);
            node = node.next;
        }
    }

    private void readObject(@NonNull ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.size = in.readInt();
        if (this.size <= 0) {
            return;
        }
        this.first = new Node<Object>(null, in.readObject(), null);
        Node<Object> node = this.first;
        for (int i = 1; i < this.size; ++i) {
            Node<Object> next = new Node<Object>(node, in.readObject(), null);
            node.next = next;
            node = next;
        }
        this.last = node;
    }

    protected static class Node<E> {
        E item;
        @Nullable Node<E> next;
        @Nullable Node<E> prev;

        Node(@Nullable Node<E> prev, E element, @Nullable Node<E> next) {
            this.item = element;
            this.next = next;
            this.prev = prev;
        }
    }
}

