/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.mutable;

import dyvil.annotation.internal.NonNull;
import dyvil.collection.ImmutableSet;
import dyvil.collection.MutableSet;
import dyvil.collection.Set;
import dyvil.collection.SizedIterable;
import dyvil.collection.impl.AbstractIdentityHashMap;
import dyvil.collection.impl.AbstractIdentityHashSet;
import dyvil.lang.LiteralConvertible;
import java.util.function.Function;
import java.util.function.Predicate;

@LiteralConvertible.FromArray
public class IdentityHashSet<E>
extends AbstractIdentityHashSet<E>
implements MutableSet<E> {
    private static final long serialVersionUID = 5634688694810236366L;
    private float loadFactor;
    private transient int threshold;

    public static <E> @NonNull IdentityHashSet<E> apply() {
        return new IdentityHashSet<E>();
    }

    @SafeVarargs
    public static <E> @NonNull IdentityHashSet<E> apply(E ... elements) {
        return new IdentityHashSet<E>(elements);
    }

    public static <E> @NonNull IdentityHashSet<E> from(@NonNull Iterable<? extends E> iterable) {
        return new IdentityHashSet<E>(iterable);
    }

    public static <E> @NonNull IdentityHashSet<E> from(@NonNull SizedIterable<? extends E> iterable) {
        return new IdentityHashSet<E>(iterable);
    }

    public static <E> @NonNull IdentityHashSet<E> from(@NonNull Set<? extends E> iterable) {
        return new IdentityHashSet<E>(iterable);
    }

    public static <E> @NonNull IdentityHashSet<E> from(@NonNull AbstractIdentityHashSet<? extends E> iterable) {
        return new IdentityHashSet<E>(iterable);
    }

    public IdentityHashSet() {
        this(16, 0.6666667f);
    }

    public IdentityHashSet(int capacity) {
        this(capacity, 0.6666667f);
    }

    public IdentityHashSet(float loadFactor) {
        this(16, loadFactor);
    }

    public IdentityHashSet(int capacity, float loadFactor) {
        super(capacity);
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Invalid Load Factor: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)Math.min((float)capacity * loadFactor, 2.1474836E9f);
    }

    public IdentityHashSet(E @NonNull [] elements) {
        super(elements);
        this.defaultLoadFactor();
    }

    public IdentityHashSet(@NonNull Iterable<? extends E> iterable) {
        super(iterable);
        this.defaultLoadFactor();
    }

    public IdentityHashSet(@NonNull SizedIterable<? extends E> iterable) {
        super(iterable);
        this.defaultLoadFactor();
    }

    public IdentityHashSet(@NonNull Set<? extends E> set) {
        super(set);
        this.defaultLoadFactor();
    }

    public IdentityHashSet(@NonNull AbstractIdentityHashSet<? extends E> identityHashSet) {
        super(identityHashSet);
        this.defaultLoadFactor();
    }

    private void defaultLoadFactor() {
        this.loadFactor = 0.6666667f;
        this.updateThreshold(this.table.length);
    }

    @Override
    protected void updateThreshold(int newCapacity) {
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    @Override
    public void clear() {
        this.size = 0;
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
    }

    @Override
    public boolean add(E element) {
        return this.addInternal(element);
    }

    @Override
    protected void addElement(int index, Object element) {
        this.table[index] = element;
        if (++this.size >= this.threshold) {
            this.flatten();
        }
    }

    @Override
    public boolean remove(Object key) {
        Object k = AbstractIdentityHashMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = AbstractIdentityHashMap.index(k, len);
        while (true) {
            Object item;
            if ((item = tab[i]) == k) {
                --this.size;
                tab[i] = null;
                this.closeDeletion(i);
                return true;
            }
            if (item == null) {
                return false;
            }
            i = IdentityHashSet.nextIndex(i, len);
        }
    }

    private void closeDeletion(int index) {
        Object item;
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityHashSet.nextIndex(index, len);
        while ((item = tab[i]) != null) {
            int r = AbstractIdentityHashMap.index(item, len);
            if (i < r && (r <= index || index <= i) || r <= index && index <= i) {
                tab[index] = item;
                tab[i] = null;
                index = i;
            }
            i = IdentityHashSet.nextIndex(i, len);
        }
    }

    @Override
    public void map(@NonNull Function<? super E, ? extends E> mapper) {
        for (int i = 0; i < this.table.length; ++i) {
            Object o = this.table[i];
            if (o == null) continue;
            this.table[i] = AbstractIdentityHashMap.maskNull(mapper.apply(AbstractIdentityHashMap.unmaskNull(o)));
        }
    }

    @Override
    public void flatMap(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends E>> mapper) {
        IdentityHashSet<E> copy = new IdentityHashSet<E>(this.size, this.loadFactor);
        for (Object element : this) {
            for (E result : mapper.apply(element)) {
                copy.addInternal(result);
            }
        }
        this.table = copy.table;
        this.size = copy.size;
        this.threshold = copy.threshold;
    }

    @Override
    public void filter(@NonNull Predicate<? super E> predicate) {
        for (int i = 0; i < this.table.length; ++i) {
            Object o = this.table[i];
            if (o == null || predicate.test(AbstractIdentityHashMap.unmaskNull(o))) continue;
            this.table[i] = null;
        }
    }

    @Override
    public @NonNull MutableSet<E> copy() {
        return this.mutableCopy();
    }

    @Override
    public @NonNull ImmutableSet<E> immutable() {
        return this.immutableCopy();
    }
}

