/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.mutable;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableMap;
import dyvil.collection.Map;
import dyvil.collection.MutableMap;
import dyvil.collection.Set;
import dyvil.collection.SizedIterable;
import dyvil.collection.impl.AbstractIdentityHashMap;
import dyvil.lang.LiteralConvertible;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

@LiteralConvertible.FromArray
public class IdentityHashMap<K, V>
extends AbstractIdentityHashMap<K, V>
implements MutableMap<K, V> {
    private static final long serialVersionUID = -2508405537563871840L;
    private float loadFactor;
    private transient int threshold;

    public static <K, V> @NonNull IdentityHashMap<K, V> singleton(K key, V value) {
        IdentityHashMap<K, V> result = new IdentityHashMap<K, V>(1);
        result.putInternal(key, value);
        return result;
    }

    public static <K, V> @NonNull IdentityHashMap<K, V> apply() {
        return new IdentityHashMap<K, V>();
    }

    @SafeVarargs
    public static <K, V> @NonNull IdentityHashMap<K, V> apply(Entry<? extends K, ? extends V> ... entries) {
        return new IdentityHashMap<K, V>(entries);
    }

    public static <K, V> @NonNull IdentityHashMap<K, V> from(@NonNull Entry<? extends K, ? extends V> @NonNull [] entries) {
        return new IdentityHashMap<K, V>(entries);
    }

    public static <K, V> @NonNull IdentityHashMap<K, V> from(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        return new IdentityHashMap<K, V>(iterable);
    }

    public static <K, V> @NonNull IdentityHashMap<K, V> from(@NonNull SizedIterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        return new IdentityHashMap<K, V>(iterable);
    }

    public static <K, V> @NonNull IdentityHashMap<K, V> from(@NonNull Set<? extends @NonNull Entry<? extends K, ? extends V>> set) {
        return new IdentityHashMap<K, V>(set);
    }

    public static <K, V> @NonNull IdentityHashMap<K, V> from(@NonNull Map<? extends K, ? extends V> map) {
        return new IdentityHashMap<K, V>(map);
    }

    public static <K, V> @NonNull IdentityHashMap<K, V> from(@NonNull AbstractIdentityHashMap<? extends K, ? extends V> identityHashMap) {
        return new IdentityHashMap<K, V>(identityHashMap);
    }

    public IdentityHashMap() {
        this(12, 0.6666667f);
    }

    public IdentityHashMap(int capacity) {
        this(capacity, 0.6666667f);
    }

    public IdentityHashMap(float loadFactor) {
        this(12, loadFactor);
    }

    public IdentityHashMap(int capacity, float loadFactor) {
        super(capacity);
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Invalid Load Factor: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)Math.min((float)capacity * loadFactor, 2.1474836E9f);
    }

    public IdentityHashMap(Entry<? extends K, ? extends V> @NonNull [] entries) {
        super(entries);
        this.defaultLoadFactor();
    }

    public IdentityHashMap(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        super(iterable);
        this.defaultLoadFactor();
    }

    public IdentityHashMap(SizedIterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        super(iterable);
        this.defaultLoadFactor();
    }

    public IdentityHashMap(@NonNull Set<? extends @NonNull Entry<? extends K, ? extends V>> set) {
        super(set);
        this.defaultLoadFactor();
    }

    public IdentityHashMap(@NonNull Map<? extends K, ? extends V> map) {
        super(map);
        this.defaultLoadFactor();
    }

    public IdentityHashMap(@NonNull AbstractIdentityHashMap<? extends K, ? extends V> identityHashMap) {
        super(identityHashMap);
        this.defaultLoadFactor();
    }

    private void defaultLoadFactor() {
        this.loadFactor = 0.6666667f;
        this.updateThreshold(this.table.length >> 1);
    }

    @Override
    protected void updateThreshold(int newCapacity) {
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    @Override
    public @Nullable Entry<K, V> getEntry(final Object key) {
        if (!this.containsKey(key)) {
            return null;
        }
        return new Entry<K, V>(){

            @Override
            public @NonNull K getKey() {
                return key;
            }

            @Override
            public @NonNull V getValue() {
                int index = IdentityHashMap.this.getIndex(key);
                return IdentityHashMap.this.table[index];
            }
        };
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.table, null);
    }

    @Override
    public @Nullable V put(K key, V value) {
        return this.putInternal(key, value);
    }

    @Override
    public void putAll(@NonNull Map<? extends K, ? extends V> map) {
        this.putAllInternal(map);
    }

    @Override
    protected void addEntry(int index, Object key, V value) {
        this.table[index] = key;
        this.table[index + 1] = value;
        if (++this.size >= this.threshold) {
            this.flatten();
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Object item;
        Object maskedKey = IdentityHashMap.maskNull(key);
        Object[] table = this.table;
        int len = table.length;
        int i = IdentityHashMap.index(maskedKey, len);
        while ((item = table[i]) != null) {
            if (item == maskedKey) {
                return (V)table[i + 1];
            }
            i = IdentityHashMap.nextKeyIndex(i, len);
        }
        this.addEntry(i, maskedKey, value);
        return value;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Object item;
        Object k = IdentityHashMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityHashMap.index(k, len);
        while ((item = tab[i]) != null) {
            if (item == k) {
                if (tab[i + 1] != oldValue) {
                    return false;
                }
                tab[i + 1] = newValue;
                return true;
            }
            i = IdentityHashMap.nextKeyIndex(i, len);
        }
        return false;
    }

    @Override
    public @Nullable V replace(K key, V newValue) {
        Object item;
        Object k = IdentityHashMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityHashMap.index(k, len);
        while ((item = tab[i]) != null) {
            if (item == k) {
                Object oldValue = tab[i + 1];
                tab[i + 1] = newValue;
                return (V)oldValue;
            }
            i = IdentityHashMap.nextKeyIndex(i, len);
        }
        return null;
    }

    private void closeDeletion(int index) {
        Object item;
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityHashMap.nextKeyIndex(index, len);
        while ((item = tab[i]) != null) {
            int r = IdentityHashMap.index(item, len);
            if (i < r && (r <= index || index <= i) || r <= index && index <= i) {
                tab[index] = item;
                tab[index + 1] = tab[i + 1];
                tab[i] = null;
                tab[i + 1] = null;
                index = i;
            }
            i = IdentityHashMap.nextKeyIndex(i, len);
        }
    }

    @Override
    public @Nullable V removeKey(Object key) {
        Object k = IdentityHashMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityHashMap.index(k, len);
        while (true) {
            Object item;
            if ((item = tab[i]) == k) {
                --this.size;
                Object oldValue = tab[i + 1];
                tab[i + 1] = null;
                tab[i] = null;
                this.closeDeletion(i);
                return (V)oldValue;
            }
            if (item == null) {
                return null;
            }
            i = IdentityHashMap.nextKeyIndex(i, len);
        }
    }

    @Override
    public boolean removeValue(Object value) {
        boolean removed = false;
        Object[] tab = this.table;
        for (int i = 1; i < tab.length; i += 2) {
            if (tab[i] != value || tab[i - 1] == null) continue;
            tab[i - 1] = null;
            tab[i] = null;
            removed = true;
            this.closeDeletion(i);
        }
        return removed;
    }

    @Override
    public boolean remove(Object key, Object value) {
        Object k = IdentityHashMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityHashMap.index(k, len);
        while (true) {
            Object item;
            if ((item = tab[i]) == k) {
                if (tab[i + 1] != value) {
                    return false;
                }
                --this.size;
                tab[i] = null;
                tab[i + 1] = null;
                this.closeDeletion(i);
                return true;
            }
            if (item == null) {
                return false;
            }
            i = IdentityHashMap.nextKeyIndex(i, len);
        }
    }

    @Override
    public void mapValues(@NonNull BiFunction<? super K, ? super V, ? extends V> mapper) {
        Object[] tab = this.table;
        for (int i = 0; i < tab.length; i += 2) {
            Object key = tab[i];
            if (key == null) continue;
            tab[i + 1] = mapper.apply(IdentityHashMap.unmaskNull(key), tab[i + 1]);
        }
    }

    @Override
    public void filter(@NonNull BiPredicate<? super K, ? super V> condition) {
        Object[] tab = this.table;
        for (int i = 0; i < tab.length; i += 2) {
            Object key = tab[i];
            if (key == null || condition.test(IdentityHashMap.unmaskNull(tab[i]), tab[i + 1])) continue;
            tab[i + 1] = null;
            tab[i] = null;
            this.closeDeletion(i);
        }
    }

    @Override
    public @NonNull MutableMap<K, V> copy() {
        return this.mutableCopy();
    }

    @Override
    public @NonNull ImmutableMap<K, V> immutable() {
        return this.immutableCopy();
    }
}

