/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.mutable;

import dyvil.annotation.internal.NonNull;
import dyvil.collection.ImmutableSet;
import dyvil.collection.MutableSet;
import dyvil.collection.Set;
import dyvil.collection.SizedIterable;
import dyvil.collection.impl.AbstractHashMap;
import dyvil.collection.impl.AbstractHashSet;
import dyvil.lang.LiteralConvertible;
import dyvil.math.MathUtils;
import java.util.Objects;
import java.util.function.Function;

@LiteralConvertible.FromArray
public class HashSet<E>
extends AbstractHashSet<E>
implements MutableSet<E> {
    private static final long serialVersionUID = -993127062150101200L;
    private float loadFactor;
    private transient int threshold;

    public static <E> @NonNull HashSet<E> apply() {
        return new HashSet<E>();
    }

    @SafeVarargs
    public static <E> @NonNull HashSet<E> apply(E ... elements) {
        return new HashSet<E>(elements);
    }

    public static <E> @NonNull HashSet<E> from(E @NonNull [] array) {
        return new HashSet<E>(array);
    }

    public static <E> @NonNull HashSet<E> from(@NonNull Iterable<? extends E> iterable) {
        return new HashSet<E>(iterable);
    }

    public static <E> @NonNull HashSet<E> from(@NonNull SizedIterable<? extends E> iterable) {
        return new HashSet<E>(iterable);
    }

    public static <E> @NonNull HashSet<E> from(@NonNull Set<? extends E> set) {
        return new HashSet<E>(set);
    }

    public static <E> @NonNull HashSet<E> from(@NonNull AbstractHashSet<? extends E> hashSet) {
        return new HashSet<E>(hashSet);
    }

    public HashSet() {
        this(16, 0.75f);
    }

    public HashSet(int capacity) {
        this(capacity, 0.75f);
    }

    public HashSet(float loadFactor) {
        this(16, loadFactor);
    }

    public HashSet(int capacity, float loadFactor) {
        super(capacity);
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Invalid Load Factor: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * this.loadFactor);
    }

    public HashSet(E @NonNull [] elements) {
        super(elements);
        this.defaultThreshold();
    }

    public HashSet(@NonNull Iterable<? extends E> iterable) {
        super(iterable);
        this.defaultThreshold();
    }

    public HashSet(@NonNull SizedIterable<? extends E> iterable) {
        super(iterable);
        this.defaultThreshold();
    }

    public HashSet(@NonNull Set<? extends E> set) {
        super(set);
        this.defaultThreshold();
    }

    public HashSet(@NonNull AbstractHashSet<? extends E> hashSet) {
        super(hashSet);
        this.defaultThreshold();
    }

    private void defaultThreshold() {
        this.loadFactor = 0.75f;
        this.threshold = (int)((float)this.elements.length * 0.75f);
    }

    @Override
    protected void updateThreshold(int newCapacity) {
        this.threshold = (int)Math.min((float)newCapacity * this.loadFactor, 2.1474836E9f);
    }

    @Override
    public void clear() {
        this.size = 0;
        int length = this.elements.length;
        for (int i = 0; i < length; ++i) {
            this.elements[i] = null;
        }
    }

    @Override
    protected void addElement(int hash, E element, int index) {
        AbstractHashSet.HashElement[] tab = this.elements;
        if (this.size >= this.threshold) {
            this.flatten();
            tab = this.elements;
            hash = AbstractHashMap.hash(element);
            index = AbstractHashMap.index(hash, tab.length);
        }
        tab[index] = new AbstractHashSet.HashElement<E>(element, hash, tab[index]);
        ++this.size;
    }

    @Override
    public boolean add(E element) {
        return this.addInternal(element);
    }

    @Override
    public boolean remove(Object element) {
        AbstractHashSet.HashElement prev;
        int hash = AbstractHashMap.hash(element);
        int i = AbstractHashMap.index(hash, this.elements.length);
        AbstractHashSet.HashElement e = prev = this.elements[i];
        while (e != null) {
            Object k;
            AbstractHashSet.HashElement next = e.next;
            if (e.hash == hash && ((k = e.element) == element || Objects.equals(element, k))) {
                --this.size;
                if (prev == e) {
                    this.elements[i] = next;
                } else {
                    prev.next = next;
                }
                return true;
            }
            prev = e;
            e = next;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void map(@NonNull Function<? super E, ? extends E> mapper) {
        int len = MathUtils.nextPowerOf2(this.size);
        AbstractHashSet.HashElement[] newElements = new AbstractHashSet.HashElement[len];
        int size = 0;
        for (AbstractHashSet.HashElement hashElement : this.elements) {
            void var8_8;
            while (var8_8 != null) {
                block4: {
                    E newElement = mapper.apply(var8_8.element);
                    int hash = AbstractHashMap.hash(newElement);
                    int index = AbstractHashMap.index(hash, len);
                    AbstractHashSet.HashElement oldElement = newElements[index];
                    while (oldElement != null) {
                        if (oldElement.hash != hash || !Objects.equals(oldElement.element, newElement)) {
                            oldElement = oldElement.next;
                            continue;
                        }
                        break block4;
                    }
                    ++size;
                    newElements[index] = new AbstractHashSet.HashElement<E>(newElement, hash, newElements[index]);
                }
                AbstractHashSet.HashElement hashElement2 = var8_8.next;
            }
        }
        this.elements = newElements;
        this.size = size;
    }

    @Override
    public void flatMap(@NonNull Function<? super E, ? extends @NonNull Iterable<? extends E>> mapper) {
        HashSet<E> copy = new HashSet<E>(this.size << 2, this.loadFactor);
        for (Object element : this) {
            for (E newElement : mapper.apply(element)) {
                copy.add(newElement);
            }
        }
        this.size = copy.size;
        this.elements = copy.elements;
        this.threshold = copy.threshold;
    }

    @Override
    public @NonNull MutableSet<E> copy() {
        return this.mutableCopy();
    }

    @Override
    public @NonNull ImmutableSet<E> immutable() {
        return this.immutableCopy();
    }
}

