/*
 * Decompiled with CFR 0.152.
 */
package dyvil.collection.mutable;

import dyvil.annotation.internal.NonNull;
import dyvil.annotation.internal.Nullable;
import dyvil.collection.Entry;
import dyvil.collection.ImmutableMap;
import dyvil.collection.Map;
import dyvil.collection.MutableMap;
import dyvil.collection.Set;
import dyvil.collection.SizedIterable;
import dyvil.collection.impl.AbstractHashMap;
import dyvil.lang.LiteralConvertible;
import dyvil.ref.ObjectRef;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

@LiteralConvertible.FromArray
public class HashMap<K, V>
extends AbstractHashMap<K, V>
implements MutableMap<K, V> {
    private static final long serialVersionUID = -5390749229591621243L;
    private float loadFactor;
    private transient int threshold;

    public static <K, V> @NonNull HashMap<K, V> singleton(K key, V value) {
        HashMap<K, V> result = new HashMap<K, V>();
        result.putInternal(key, value);
        return result;
    }

    public static <K, V> @NonNull HashMap<K, V> apply() {
        return new HashMap<K, V>();
    }

    @SafeVarargs
    public static <K, V> @NonNull HashMap<K, V> apply(Entry<K, V> ... entries) {
        return new HashMap<K, V>(entries);
    }

    public static <K, V> @NonNull HashMap<K, V> from(@NonNull Entry<? extends K, ? extends V> @NonNull [] array) {
        return new HashMap<K, V>(array);
    }

    public static <K, V> @NonNull HashMap<K, V> from(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        return new HashMap<K, V>(iterable);
    }

    public static <K, V> @NonNull HashMap<K, V> from(@NonNull SizedIterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        return new HashMap<K, V>(iterable);
    }

    public static <K, V> @NonNull HashMap<K, V> from(@NonNull Set<? extends @NonNull Entry<? extends K, ? extends V>> set) {
        return new HashMap<K, V>(set);
    }

    public static <K, V> @NonNull HashMap<K, V> from(@NonNull Map<? extends K, ? extends V> map) {
        return new HashMap<K, V>(map);
    }

    public static <K, V> @NonNull HashMap<K, V> from(@NonNull AbstractHashMap<? extends K, ? extends V> hashMap) {
        return new HashMap<K, V>(hashMap);
    }

    public HashMap() {
        this(16, 0.75f);
    }

    public HashMap(int capacity) {
        this(capacity, 0.75f);
    }

    public HashMap(float loadFactor) {
        this(16, loadFactor);
    }

    public HashMap(int capacity, float loadFactor) {
        super(capacity);
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Invalid Load Factor: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)Math.min((float)capacity * loadFactor, 2.1474836E9f);
    }

    public HashMap(@NonNull Entry<? extends K, ? extends V> @NonNull [] entries) {
        super(entries);
        this.defaultLoadFactor();
    }

    public HashMap(@NonNull Iterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        super(iterable);
        this.defaultLoadFactor();
    }

    public HashMap(@NonNull SizedIterable<? extends @NonNull Entry<? extends K, ? extends V>> iterable) {
        super(iterable);
        this.defaultLoadFactor();
    }

    public HashMap(@NonNull Set<? extends @NonNull Entry<? extends K, ? extends V>> set) {
        super(set);
        this.defaultLoadFactor();
    }

    public HashMap(@NonNull Map<? extends K, ? extends V> map) {
        super(map);
        this.defaultLoadFactor();
    }

    public HashMap(@NonNull AbstractHashMap<? extends K, ? extends V> map) {
        super(map);
        this.defaultLoadFactor();
    }

    private void defaultLoadFactor() {
        this.loadFactor = 0.75f;
        this.threshold = (int)((float)this.entries.length * 0.75f);
    }

    @Override
    protected void updateThreshold(int newCapacity) {
        this.threshold = (int)Math.min((float)newCapacity * this.loadFactor, 2.1474836E9f);
    }

    @Override
    public void clear() {
        this.size = 0;
        int length = this.entries.length;
        for (int i = 0; i < length; ++i) {
            this.entries[i] = null;
        }
    }

    @Override
    public void subscript_$eq(K key, V value) {
        this.putInternal(key, value);
    }

    @Override
    public @NonNull ObjectRef<V> subscript_$amp(K key) {
        return this.getEntryInternal(key);
    }

    @Override
    public @Nullable V put(@Nullable K key, V value) {
        int hash = HashMap.hash(key);
        int i = HashMap.index(hash, this.entries.length);
        AbstractHashMap.HashEntry e = this.entries[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                Object oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        this.addEntry(hash, key, value, i);
        return null;
    }

    @Override
    protected void addEntry(int hash, K key, V value, int index) {
        AbstractHashMap.HashEntry[] tab = this.entries;
        if (this.size >= this.threshold) {
            this.flatten();
            tab = this.entries;
            hash = HashMap.hash(key);
            index = HashMap.index(hash, tab.length);
        }
        tab[index] = new AbstractHashMap.HashEntry<K, V>(key, value, hash, tab[index]);
        ++this.size;
    }

    @Override
    public void putAll(@NonNull Map<? extends K, ? extends V> map) {
        this.putAllInternal(map);
    }

    @Override
    public @Nullable V putIfAbsent(@Nullable K key, V value) {
        int hash = HashMap.hash(key);
        int i = HashMap.index(hash, this.entries.length);
        AbstractHashMap.HashEntry e = this.entries[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                return e.value;
            }
            e = e.next;
        }
        this.addEntry(hash, key, value, i);
        return value;
    }

    @Override
    public boolean replace(@Nullable K key, V oldValue, V newValue) {
        int hash = HashMap.hash(key);
        int i = HashMap.index(hash, this.entries.length);
        AbstractHashMap.HashEntry e = this.entries[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                if (!Objects.equals(oldValue, newValue)) {
                    return false;
                }
                e.value = newValue;
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public @Nullable V replace(@Nullable K key, V newValue) {
        int hash = HashMap.hash(key);
        int i = HashMap.index(hash, this.entries.length);
        AbstractHashMap.HashEntry e = this.entries[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                Object oldValue = e.value;
                e.value = newValue;
                return oldValue;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public @Nullable V removeKey(@Nullable Object key) {
        AbstractHashMap.HashEntry prev;
        int hash = HashMap.hash(key);
        int i = HashMap.index(hash, this.entries.length);
        AbstractHashMap.HashEntry e = prev = this.entries[i];
        while (e != null) {
            Object k;
            AbstractHashMap.HashEntry next = e.next;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                --this.size;
                if (prev == e) {
                    this.entries[i] = next;
                } else {
                    prev.next = next;
                }
                return e.value;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    @Override
    public boolean removeValue(@Nullable Object value) {
        for (int i = 0; i < this.entries.length; ++i) {
            AbstractHashMap.HashEntry prev;
            AbstractHashMap.HashEntry e = prev = this.entries[i];
            while (e != null) {
                AbstractHashMap.HashEntry next = e.next;
                Object v = e.value;
                if (v == value || value != null && value.equals(v)) {
                    --this.size;
                    if (prev == e) {
                        this.entries[i] = next;
                    } else {
                        prev.next = next;
                    }
                    return true;
                }
                prev = e;
                e = next;
            }
        }
        return false;
    }

    @Override
    public boolean remove(@Nullable Object key, Object value) {
        AbstractHashMap.HashEntry prev;
        int hash = HashMap.hash(key);
        int i = HashMap.index(hash, this.entries.length);
        AbstractHashMap.HashEntry e = prev = this.entries[i];
        while (e != null) {
            Object k;
            AbstractHashMap.HashEntry next = e.next;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                if (!Objects.equals(value, e.value)) {
                    return false;
                }
                --this.size;
                if (prev == e) {
                    this.entries[i] = next;
                } else {
                    prev.next = next;
                }
                return true;
            }
            prev = e;
            e = next;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void mapValues(@NonNull BiFunction<? super K, ? super V, ? extends V> mapper) {
        for (AbstractHashMap.HashEntry hashEntry : this.entries) {
            void var5_5;
            while (var5_5 != null) {
                var5_5.value = mapper.apply(var5_5.key, var5_5.value);
                AbstractHashMap.HashEntry hashEntry2 = var5_5.next;
            }
        }
    }

    @Override
    public void filter(@NonNull BiPredicate<? super K, ? super V> condition) {
        for (int i = 0; i < this.entries.length; ++i) {
            AbstractHashMap.HashEntry prev;
            AbstractHashMap.HashEntry e = prev = this.entries[i];
            while (e != null) {
                AbstractHashMap.HashEntry next = e.next;
                if (!condition.test(e.key, e.value)) {
                    --this.size;
                    if (prev == e) {
                        this.entries[i] = next;
                    } else {
                        prev.next = next;
                    }
                }
                prev = e;
                e = next;
            }
        }
    }

    @Override
    public @NonNull MutableMap<K, V> copy() {
        return this.mutableCopy();
    }

    @Override
    public @NonNull ImmutableMap<K, V> immutable() {
        return this.immutableCopy();
    }
}

